/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.item;

import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.ItemStorageUtils;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J.\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralium/storages/item/ItemHandlerWrapper;", "Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "handler", "Lnet/minecraftforge/items/IItemHandler;", "(Lnet/minecraftforge/items/IItemHandler;)V", "size", "", "getSize", "()I", "canPlaceItem", "", "slot", "item", "Lnet/minecraft/world/item/ItemStack;", "getItem", "setChanged", "", "storeItem", "stack", "startSlot", "endSlot", "takeItems", "limit", "predicate", "Ljava/util/function/Predicate;", "peripheralium-forge-1.20.1"})
public final class ItemHandlerWrapper
implements SlottedItemStorage {
    @NotNull
    private final IItemHandler handler;

    public ItemHandlerWrapper(@NotNull IItemHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
    }

    @Override
    @NotNull
    public ItemStack takeItems(int limit, int startSlot, int endSlot, @NotNull Predicate<ItemStack> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        int slidingLimit = limit;
        ItemStack slidingItemStack = ItemStack.f_41583_;
        int currentSlot = startSlot;
        if (currentSlot <= endSlot) {
            while (true) {
                ItemStack tryExtractedStack;
                Intrinsics.checkNotNullExpressionValue((Object)this.handler.extractItem(currentSlot, limit, true), (String)"handler.extractItem(currentSlot, limit, true)");
                if (!tryExtractedStack.m_41619_() && predicate.test(tryExtractedStack)) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.handler.extractItem(currentSlot, limit, false), (String)"handler.extractItem(currentSlot, limit, false)");
                    if (slidingItemStack.m_41619_()) {
                        slidingItemStack = extractedStack;
                        slidingLimit = Math.min(slidingItemStack.m_41741_(), limit);
                        slidingLimit -= extractedStack.m_41613_();
                    } else {
                        ItemStack itemStack = slidingItemStack;
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"slidingItemStack");
                        if (ItemStorageUtils.canMerge$default(ItemStorageUtils.INSTANCE, itemStack, extractedStack, 0, 4, null)) {
                            int extractedCount = extractedStack.m_41613_();
                            ItemStack itemStack2 = slidingItemStack;
                            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"slidingItemStack");
                            ItemStack remainExtracted = ItemStorageUtils.inplaceMerge$default(ItemStorageUtils.INSTANCE, itemStack2, extractedStack, 0, 4, null);
                            if (!remainExtracted.m_41619_()) {
                                this.handler.insertItem(currentSlot, remainExtracted, false);
                            }
                            slidingLimit -= extractedCount - remainExtracted.m_41613_();
                        } else {
                            this.handler.insertItem(currentSlot, extractedStack, false);
                        }
                    }
                    if (slidingLimit <= 0) break;
                }
                if (currentSlot == endSlot) break;
                ++currentSlot;
            }
        }
        ItemStack itemStack = slidingItemStack;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"slidingItemStack");
        return itemStack;
    }

    @Override
    @NotNull
    public ItemStack getItem(int slot) {
        ItemStack itemStack = this.handler.getStackInSlot(slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"handler.getStackInSlot(slot)");
        return itemStack;
    }

    @Override
    public boolean canPlaceItem(int slot, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return true;
    }

    @Override
    @NotNull
    public ItemStack storeItem(@NotNull ItemStack stack, int startSlot, int endSlot) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ItemStack slidingItemStack = stack;
        int currentSlot = startSlot;
        if (currentSlot <= endSlot) {
            while (true) {
                Intrinsics.checkNotNullExpressionValue((Object)this.handler.insertItem(currentSlot, slidingItemStack, false), (String)"handler.insertItem(curre\u2026 slidingItemStack, false)");
                if (slidingItemStack.m_41619_() || currentSlot == endSlot) break;
                ++currentSlot;
            }
        }
        return slidingItemStack;
    }

    @Override
    public void setChanged() {
    }

    @Override
    public int getSize() {
        return this.handler.getSlots();
    }

    @Override
    @NotNull
    public ItemStack takeItems(@NotNull Predicate<ItemStack> predicate, int limit) {
        return SlottedItemStorage.DefaultImpls.takeItems(this, predicate, limit);
    }

    @Override
    @NotNull
    public ItemStack storeItem(@NotNull ItemStack stack) {
        return SlottedItemStorage.DefaultImpls.storeItem(this, stack);
    }

    @Override
    @NotNull
    public ItemStack storeItem(@NotNull ItemStack stack, int startSlot) {
        return SlottedItemStorage.DefaultImpls.storeItem(this, stack, startSlot);
    }

    @Override
    @NotNull
    public Iterator<ItemStack> getItems() {
        return SlottedItemStorage.DefaultImpls.getItems(this);
    }

    @Override
    public int moveTo(@NotNull ItemSink to, int limit, int fromSlot, int toSlot, @NotNull Predicate<ItemStack> takePredicate) {
        return SlottedItemStorage.DefaultImpls.moveTo(this, to, limit, fromSlot, toSlot, takePredicate);
    }

    @Override
    public int moveTo(@NotNull ItemSink to, int limit, int toSlot, @NotNull Predicate<ItemStack> takePredicate) {
        return SlottedItemStorage.DefaultImpls.moveTo(this, to, limit, toSlot, takePredicate);
    }

    @Override
    public int moveFrom(@NotNull ItemStorage from, int limit, int fromSlot, @NotNull Predicate<ItemStack> takePredicate) {
        return SlottedItemStorage.DefaultImpls.moveFrom(this, from, limit, fromSlot, takePredicate);
    }

    @Override
    public int moveFrom(@NotNull ItemStorage from, int limit, int toSlot, int fromSlot, @NotNull Predicate<ItemStack> takePredicate) {
        return SlottedItemStorage.DefaultImpls.moveFrom(this, from, limit, toSlot, fromSlot, takePredicate);
    }

    @Override
    @Nullable
    public String getMovableType() {
        return SlottedItemStorage.DefaultImpls.getMovableType(this);
    }
}

