/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.fluid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.fluid.ExtensionsKt;
import site.siredvin.peripheralium.storages.fluid.FluidSink;
import site.siredvin.peripheralium.storages.fluid.FluidStack;
import site.siredvin.peripheralium.storages.fluid.FluidStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u001e\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lsite/siredvin/peripheralium/storages/fluid/ForgeFluidStorage;", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "handler", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "(Lnet/minecraftforge/fluids/capability/IFluidHandler;)V", "getFluids", "", "Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "setChanged", "", "storeFluid", "stack", "takeFluid", "predicate", "Ljava/util/function/Predicate;", "limit", "", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nForgeFluidStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForgeFluidStorage.kt\nsite/siredvin/peripheralium/storages/fluid/ForgeFluidStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1549#2:55\n1620#2,3:56\n*S KotlinDebug\n*F\n+ 1 ForgeFluidStorage.kt\nsite/siredvin/peripheralium/storages/fluid/ForgeFluidStorage\n*L\n9#1:55\n9#1:56,3\n*E\n"})
public final class ForgeFluidStorage
implements FluidStorage {
    @NotNull
    private final IFluidHandler handler;

    public ForgeFluidStorage(@NotNull IFluidHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<FluidStack> getFluids() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.handler.getTanks());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            net.minecraftforge.fluids.FluidStack fluidStack = this.handler.getFluidInTank((int)it);
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"handler.getFluidInTank(it)");
            collection.add(ExtensionsKt.toVanilla(fluidStack));
        }
        return ((List)destination$iv$iv).iterator();
    }

    @Override
    @NotNull
    public FluidStack takeFluid(@NotNull Predicate<FluidStack> predicate, long limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        long realLimit = limit;
        net.minecraftforge.fluids.FluidStack forgeStack = net.minecraftforge.fluids.FluidStack.EMPTY;
        int n = this.handler.getTanks();
        for (int i = 0; i < n; ++i) {
            net.minecraftforge.fluids.FluidStack extractedStack;
            net.minecraftforge.fluids.FluidStack storedFluid;
            Intrinsics.checkNotNullExpressionValue((Object)this.handler.getFluidInTank(i), (String)"handler.getFluidInTank(i)");
            if (!predicate.test(ExtensionsKt.toVanilla(storedFluid)) || !forgeStack.isEmpty() && !storedFluid.isFluidEqual(forgeStack)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)this.handler.drain(ExtensionsKt.copyWithCount(storedFluid, (int)Math.min((long)storedFluid.getAmount(), realLimit)), IFluidHandler.FluidAction.EXECUTE), (String)"handler.drain(storedFlui\u2026dler.FluidAction.EXECUTE)");
            if (extractedStack.isEmpty()) continue;
            if (!forgeStack.isEmpty()) {
                net.minecraftforge.fluids.FluidStack fluidStack = forgeStack;
                fluidStack.setAmount(fluidStack.getAmount() + extractedStack.getAmount());
            } else {
                forgeStack = extractedStack;
            }
            if ((realLimit -= (long)extractedStack.getAmount()) > 0L) continue;
            net.minecraftforge.fluids.FluidStack fluidStack = forgeStack;
            Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"forgeStack");
            return ExtensionsKt.toVanilla(fluidStack);
        }
        net.minecraftforge.fluids.FluidStack fluidStack = forgeStack;
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"forgeStack");
        return ExtensionsKt.toVanilla(fluidStack);
    }

    @Override
    @NotNull
    public FluidStack storeFluid(@NotNull FluidStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        net.minecraftforge.fluids.FluidStack forgeStack = ExtensionsKt.toForge(stack);
        int n = this.handler.getTanks();
        for (int i = 0; i < n; ++i) {
            if (!this.handler.isFluidValid(i, forgeStack)) continue;
            int filled = this.handler.fill(forgeStack, IFluidHandler.FluidAction.EXECUTE);
            forgeStack.shrink(filled);
            if (!forgeStack.isEmpty()) continue;
            return FluidStack.Companion.getEMPTY();
        }
        return ExtensionsKt.toVanilla(forgeStack);
    }

    @Override
    public void setChanged() {
    }

    @Override
    public long moveTo(@NotNull FluidSink to, long limit, @NotNull Predicate<FluidStack> takePredicate) {
        return FluidStorage.DefaultImpls.moveTo(this, to, limit, takePredicate);
    }

    @Override
    public long moveFrom(@NotNull FluidStorage from, long limit, @NotNull Predicate<FluidStack> takePredicate) {
        return FluidStorage.DefaultImpls.moveFrom(this, from, limit, takePredicate);
    }

    @Override
    @Nullable
    public String getMovableType() {
        return FluidStorage.DefaultImpls.getMovableType(this);
    }
}

