/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.energy;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.energy.Energies;
import site.siredvin.peripheralium.storages.energy.EnergyUnit;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u0006\u0010\u0012\u001a\u00020\u0000J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0005J\u0013\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0019J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005J\t\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001J\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0019J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lsite/siredvin/peripheralium/storages/energy/EnergyStack;", "", "unit", "Lsite/siredvin/peripheralium/storages/energy/EnergyUnit;", "amount", "", "(Lsite/siredvin/peripheralium/storages/energy/EnergyUnit;J)V", "getAmount", "()J", "setAmount", "(J)V", "isEmpty", "", "()Z", "getUnit", "()Lsite/siredvin/peripheralium/storages/energy/EnergyUnit;", "component1", "component2", "copy", "copyWithCount", "count", "equals", "other", "grow", "", "", "hashCode", "is", "shrink", "split", "toString", "", "Companion", "peripheralium-forge-1.20.1"})
public final class EnergyStack {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnergyUnit unit;
    private long amount;
    @NotNull
    private static final EnergyStack EMPTY = new EnergyStack(Energies.INSTANCE.getEMPTY(), 0L);

    public EnergyStack(@NotNull EnergyUnit unit, long amount) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.unit = unit;
        this.amount = amount;
    }

    @NotNull
    public final EnergyUnit getUnit() {
        return this.unit;
    }

    public final long getAmount() {
        return this.amount;
    }

    public final void setAmount(long l) {
        this.amount = l;
    }

    public final boolean isEmpty() {
        return Intrinsics.areEqual((Object)this.unit, (Object)Energies.INSTANCE.getEMPTY());
    }

    @NotNull
    public final EnergyStack copy() {
        return new EnergyStack(this.unit, this.amount);
    }

    public final boolean is(@NotNull EnergyUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return Intrinsics.areEqual((Object)unit, (Object)this.unit);
    }

    @NotNull
    public final EnergyStack copyWithCount(long count) {
        return new EnergyStack(this.unit, count);
    }

    public final void grow(int amount) {
        this.amount += (long)amount;
    }

    public final void shrink(int amount) {
        this.amount -= (long)amount;
    }

    public final void grow(long amount) {
        this.amount += amount;
    }

    public final void shrink(long amount) {
        this.amount -= amount;
    }

    @NotNull
    public final EnergyStack split(long amount) {
        if (this.amount <= amount) {
            EnergyStack fullStack = this.copy();
            this.amount = 0L;
            return fullStack;
        }
        this.shrink(amount);
        return this.copyWithCount(amount);
    }

    @NotNull
    public final EnergyUnit component1() {
        return this.unit;
    }

    public final long component2() {
        return this.amount;
    }

    @NotNull
    public final EnergyStack copy(@NotNull EnergyUnit unit, long amount) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return new EnergyStack(unit, amount);
    }

    public static /* synthetic */ EnergyStack copy$default(EnergyStack energyStack, EnergyUnit energyUnit, long l, int n, Object object) {
        if ((n & 1) != 0) {
            energyUnit = energyStack.unit;
        }
        if ((n & 2) != 0) {
            l = energyStack.amount;
        }
        return energyStack.copy(energyUnit, l);
    }

    @NotNull
    public String toString() {
        return "EnergyStack(unit=" + this.unit + ", amount=" + this.amount + ")";
    }

    public int hashCode() {
        int result = this.unit.hashCode();
        result = result * 31 + Long.hashCode(this.amount);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EnergyStack)) {
            return false;
        }
        EnergyStack energyStack = (EnergyStack)other;
        if (!Intrinsics.areEqual((Object)this.unit, (Object)energyStack.unit)) {
            return false;
        }
        return this.amount == energyStack.amount;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lsite/siredvin/peripheralium/storages/energy/EnergyStack$Companion;", "", "()V", "EMPTY", "Lsite/siredvin/peripheralium/storages/energy/EnergyStack;", "getEMPTY", "()Lsite/siredvin/peripheralium/storages/energy/EnergyStack;", "isSameEnergy", "", "first", "second", "peripheralium-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnergyStack getEMPTY() {
            return EMPTY;
        }

        public final boolean isSameEnergy(@NotNull EnergyStack first, @NotNull EnergyStack second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            return Intrinsics.areEqual((Object)first.getUnit(), (Object)second.getUnit());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

