/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages;

import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.ContainerUtils;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J.\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralium/storages/ContainerWrapper;", "Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "container", "Lnet/minecraft/world/Container;", "(Lnet/minecraft/world/Container;)V", "size", "", "getSize", "()I", "canPlaceItem", "", "slot", "item", "Lnet/minecraft/world/item/ItemStack;", "getItem", "setChanged", "", "storeItem", "stack", "startSlot", "endSlot", "takeItems", "limit", "predicate", "Ljava/util/function/Predicate;", "peripheralium-forge-1.20.1"})
public final class ContainerWrapper
implements SlottedItemStorage {
    @NotNull
    private final Container container;

    public ContainerWrapper(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.container = container;
    }

    @Override
    @NotNull
    public ItemStack takeItems(int limit, int startSlot, int endSlot, @NotNull Predicate<ItemStack> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return ContainerUtils.INSTANCE.takeItems(this.container, limit, startSlot, endSlot, predicate);
    }

    @Override
    @NotNull
    public ItemStack getItem(int slot) {
        ItemStack itemStack = this.container.m_8020_(slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"container.getItem(slot)");
        return itemStack;
    }

    @Override
    public boolean canPlaceItem(int slot, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.container.m_7013_(slot, item);
    }

    @Override
    @NotNull
    public ItemStack storeItem(@NotNull ItemStack stack, int startSlot, int endSlot) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return ContainerUtils.INSTANCE.storeItem(this.container, stack, startSlot, endSlot);
    }

    @Override
    public void setChanged() {
        this.container.m_6596_();
    }

    @Override
    public int getSize() {
        return this.container.m_6643_();
    }

    @Override
    @NotNull
    public ItemStack takeItems(@NotNull Predicate<ItemStack> predicate, int limit) {
        return SlottedItemStorage.DefaultImpls.takeItems(this, predicate, limit);
    }

    @Override
    @NotNull
    public ItemStack storeItem(@NotNull ItemStack stack) {
        return SlottedItemStorage.DefaultImpls.storeItem(this, stack);
    }

    @Override
    @NotNull
    public ItemStack storeItem(@NotNull ItemStack stack, int startSlot) {
        return SlottedItemStorage.DefaultImpls.storeItem(this, stack, startSlot);
    }

    @Override
    @NotNull
    public Iterator<ItemStack> getItems() {
        return SlottedItemStorage.DefaultImpls.getItems(this);
    }

    @Override
    public int moveTo(@NotNull ItemSink to, int limit, int fromSlot, int toSlot, @NotNull Predicate<ItemStack> takePredicate) {
        return SlottedItemStorage.DefaultImpls.moveTo(this, to, limit, fromSlot, toSlot, takePredicate);
    }

    @Override
    public int moveTo(@NotNull ItemSink to, int limit, int toSlot, @NotNull Predicate<ItemStack> takePredicate) {
        return SlottedItemStorage.DefaultImpls.moveTo(this, to, limit, toSlot, takePredicate);
    }

    @Override
    public int moveFrom(@NotNull ItemStorage from, int limit, int fromSlot, @NotNull Predicate<ItemStack> takePredicate) {
        return SlottedItemStorage.DefaultImpls.moveFrom(this, from, limit, fromSlot, takePredicate);
    }

    @Override
    public int moveFrom(@NotNull ItemStorage from, int limit, int toSlot, int fromSlot, @NotNull Predicate<ItemStack> takePredicate) {
        return SlottedItemStorage.DefaultImpls.moveFrom(this, from, limit, toSlot, fromSlot, takePredicate);
    }

    @Override
    @Nullable
    public String getMovableType() {
        return SlottedItemStorage.DefaultImpls.getMovableType(this);
    }
}

