/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.forge;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.Peripherals;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.forge.ForgeFakePlayer;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;
import site.siredvin.peripheralium.xplat.RegistryWrapper;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001^B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\r0\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J4\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\r0\u0016\"\b\b\u0000\u0010\r*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H\r0\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020+0&H\u0016J\"\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u000200H\u0016J\u0012\u00101\u001a\u0004\u0018\u00010'2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00101\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&2\u0006\u00104\u001a\u00020$H\u0016J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u00020\u000eH\u0016J\u0012\u00108\u001a\u0004\u0018\u00010+2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00108\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010&2\u0006\u00104\u001a\u00020$H\u0016J(\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020=2\u0006\u00107\u001a\u00020\u00172\u0006\u0010>\u001a\u00020?H\u0016J \u0010@\u001a\u00020A2\u0006\u0010.\u001a\u00020\u00112\u0006\u0010B\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u001dH\u0016J\u0010\u0010C\u001a\u00020A2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0014\u0010D\u001a\u0004\u0018\u0001032\b\u0010E\u001a\u0004\u0018\u00010FH\u0016J\u0012\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010E\u001a\u00020IH\u0016J8\u0010J\u001a\u00020A2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010K\u001a\u0002032\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020A2\u0006\u0010Q\u001a\u00020AH\u0016J\u0010\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u000eH\u0016J.\u0010U\u001a\u00020:2\u0006\u0010;\u001a\u00020\u001d2\u0006\u00104\u001a\u00020$2\u0006\u0010>\u001a\u00020V2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00120XH\u0016J(\u0010Y\u001a\b\u0012\u0004\u0012\u0002H\r0Z\"\u0004\b\u0000\u0010\r2\u0012\u0010[\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0]0\\H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006_"}, d2={"Lsite/siredvin/peripheralium/forge/ForgePeripheraliumPlatform;", "Lsite/siredvin/peripheralium/xplat/PeripheraliumPlatform;", "()V", "fluidCompactDivider", "", "getFluidCompactDivider", "()I", "minecraftServer", "Lnet/minecraft/server/MinecraftServer;", "getMinecraftServer", "()Lnet/minecraft/server/MinecraftServer;", "createBlockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "factory", "Ljava/util/function/BiFunction;", "Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/level/block/state/BlockState;", "block", "Lnet/minecraft/world/level/block/Block;", "createEntityType", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/Entity;", "name", "Lnet/minecraft/resources/ResourceLocation;", "Ljava/util/function/Function;", "Lnet/minecraft/world/level/Level;", "createFakePlayer", "Lnet/minecraft/server/level/ServerPlayer;", "level", "Lnet/minecraft/server/level/ServerLevel;", "profile", "Lcom/mojang/authlib/GameProfile;", "createPocketsWithUpgrade", "", "Lnet/minecraft/world/item/ItemStack;", "upgrade", "Ldan200/computercraft/api/upgrades/UpgradeData;", "Ldan200/computercraft/api/pocket/IPocketUpgrade;", "createTabBuilder", "Lnet/minecraft/world/item/CreativeModeTab$Builder;", "createTurtlesWithUpgrade", "Ldan200/computercraft/api/turtle/ITurtleUpgrade;", "getPeripheral", "Ldan200/computercraft/api/peripheral/IPeripheral;", "pos", "side", "Lnet/minecraft/core/Direction;", "getPocketUpgrade", "key", "", "stack", "getTurtleAccess", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "entity", "getTurtleUpgrade", "interactWithEntity", "Lnet/minecraft/world/InteractionResult;", "player", "hand", "Lnet/minecraft/world/InteractionHand;", "hit", "Lnet/minecraft/world/phys/EntityHitResult;", "isBlockProtected", "", "state", "isOre", "nbtHash", "tag", "Lnet/minecraft/nbt/CompoundTag;", "nbtToLua", "", "Lnet/minecraft/nbt/Tag;", "setChunkForceLoad", "modID", "owner", "Ljava/util/UUID;", "chunkPos", "Lnet/minecraft/world/level/ChunkPos;", "add", "ticking", "triggerRenderUpdate", "", "blockEntity", "useOn", "Lnet/minecraft/world/phys/BlockHitResult;", "canUseBlock", "Ljava/util/function/Predicate;", "wrap", "Lsite/siredvin/peripheralium/xplat/RegistryWrapper;", "registry", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "ForgeRegistryWrapper", "peripheralium-forge-1.20.1"})
public final class ForgePeripheraliumPlatform
implements PeripheraliumPlatform {
    @NotNull
    public static final ForgePeripheraliumPlatform INSTANCE = new ForgePeripheraliumPlatform();

    private ForgePeripheraliumPlatform() {
    }

    @Override
    public int getFluidCompactDivider() {
        return 1;
    }

    @Override
    @NotNull
    public MinecraftServer getMinecraftServer() {
        MinecraftServer minecraftServer = ServerLifecycleHooks.getCurrentServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getCurrentServer()");
        return minecraftServer;
    }

    @Override
    @NotNull
    public <T> RegistryWrapper<T> wrap(@NotNull ResourceKey<Registry<T>> registry) {
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        ResourceLocation resourceLocation = registry.m_135782_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"registry.location()");
        ForgeRegistry forgeRegistry = RegistryManager.ACTIVE.getRegistry(registry);
        Intrinsics.checkNotNullExpressionValue((Object)forgeRegistry, (String)"ACTIVE.getRegistry(registry)");
        return new ForgeRegistryWrapper(resourceLocation, forgeRegistry);
    }

    @Override
    @NotNull
    public ServerPlayer createFakePlayer(@NotNull ServerLevel level, @NotNull GameProfile profile) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return (ServerPlayer)new ForgeFakePlayer(level, profile);
    }

    @Override
    @Nullable
    public ITurtleAccess getTurtleAccess(@NotNull BlockEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof TurtleBlockEntity) {
            return ((TurtleBlockEntity)entity).getAccess();
        }
        return null;
    }

    @Override
    @Nullable
    public IPeripheral getPeripheral(@NotNull Level level, @NotNull BlockPos pos, @NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return Peripherals.getPeripheral((Level)level, (BlockPos)pos, (Direction)side, ForgePeripheraliumPlatform::getPeripheral$lambda$0);
    }

    @Override
    public boolean isBlockProtected(@NotNull BlockPos pos, @NotNull BlockState state, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.f_8924_.m_7762_(player.m_284548_(), pos, (Player)player)) {
            return true;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(player.m_9236_(), pos, state, (Player)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isCanceled();
    }

    @Override
    @NotNull
    public InteractionResult interactWithEntity(@NotNull ServerPlayer player, @NotNull InteractionHand hand, @NotNull Entity entity, @NotNull EntityHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        InteractionResult interactAt = ForgeHooks.onInteractEntityAt((Player)((Player)player), (Entity)entity, (Vec3)hit.m_82450_(), (InteractionHand)hand);
        if (interactAt == null) {
            interactAt = entity.m_7111_((Player)player, hit.m_82450_().m_82546_(entity.m_20182_()), InteractionHand.MAIN_HAND);
        }
        if (interactAt.m_19077_()) {
            InteractionResult interactionResult = interactAt;
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"interactAt");
            return interactionResult;
        }
        InteractionResult interactionResult = player.m_36157_(entity, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"player.interactOn(entity, hand)");
        return interactionResult;
    }

    @Override
    @NotNull
    public InteractionResult useOn(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BlockHitResult hit, @NotNull Predicate<BlockState> canUseBlock) {
        InteractionResult interactionResult;
        InteractionResult useResult;
        InteractionResult result;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        Intrinsics.checkNotNullParameter(canUseBlock, (String)"canUseBlock");
        Level level = player.m_9236_();
        BlockPos pos = hit.m_82425_();
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)((Player)player), (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)hit);
        if (event.isCanceled()) {
            InteractionResult interactionResult2 = event.getCancellationResult();
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult2, (String)"event.cancellationResult");
            return interactionResult2;
        }
        UseOnContext context = new UseOnContext((Player)player, InteractionHand.MAIN_HAND, hit);
        if (event.getUseItem() != Event.Result.DENY && (result = stack.onItemUseFirst(context)) != InteractionResult.PASS) {
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            return result;
        }
        BlockState block = level.m_8055_(hit.m_82425_());
        if (event.getUseBlock() != Event.Result.DENY && !block.m_60795_() && canUseBlock.test(block) && (useResult = block.m_60664_(level, (Player)player, InteractionHand.MAIN_HAND, hit)).m_19077_()) {
            Intrinsics.checkNotNullExpressionValue((Object)useResult, (String)"useResult");
            return useResult;
        }
        if (event.getUseItem() == Event.Result.DENY) {
            interactionResult = InteractionResult.PASS;
        } else {
            InteractionResult interactionResult3 = stack.m_41661_(context);
            interactionResult = interactionResult3;
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult3, (String)"stack.useOn(context)");
        }
        return interactionResult;
    }

    @Override
    public boolean setChunkForceLoad(@NotNull ServerLevel level, @NotNull String modID, @NotNull UUID owner, @NotNull ChunkPos chunkPos, boolean add, boolean ticking) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)modID, (String)"modID");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)chunkPos, (String)"chunkPos");
        return ForgeChunkManager.forceChunk((ServerLevel)level, (String)modID, (UUID)owner, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)add, (boolean)ticking);
    }

    @Override
    @Nullable
    public String nbtHash(@Nullable CompoundTag tag) {
        return NBTUtil.getNBTHash((CompoundTag)tag);
    }

    @Override
    @Nullable
    public UpgradeData<ITurtleUpgrade> getTurtleUpgrade(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return TurtleUpgrades.instance().get(stack);
    }

    @Override
    @Nullable
    public UpgradeData<IPocketUpgrade> getPocketUpgrade(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return PocketUpgrades.instance().get(stack);
    }

    @Override
    @Nullable
    public ITurtleUpgrade getTurtleUpgrade(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (ITurtleUpgrade)TurtleUpgrades.instance().get(key);
    }

    @Override
    @Nullable
    public IPocketUpgrade getPocketUpgrade(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (IPocketUpgrade)PocketUpgrades.instance().get(key);
    }

    @Override
    @Nullable
    public Object nbtToLua(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return NBTUtil.toLua((Tag)tag);
    }

    @Override
    @NotNull
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(@NotNull BiFunction<BlockPos, BlockState, T> factory, @NotNull Block block) {
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Block[] blockArray = new Block[]{block};
        BlockEntityType blockEntityType = BlockEntityType.Builder.m_155273_((arg_0, arg_1) -> ForgePeripheraliumPlatform.createBlockEntityType$lambda$1(factory, arg_0, arg_1), (Block[])blockArray).m_58966_(null);
        Intrinsics.checkNotNullExpressionValue((Object)blockEntityType, (String)"of({ t: BlockPos?, u: Bl\u2026    }, block).build(null)");
        return blockEntityType;
    }

    @Override
    @NotNull
    public <T extends Entity> EntityType<T> createEntityType(@NotNull ResourceLocation name, @NotNull Function<Level, T> factory) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        EntityType entityType = EntityType.Builder.m_20704_((arg_0, arg_1) -> ForgePeripheraliumPlatform.createEntityType$lambda$2(factory, arg_0, arg_1), (MobCategory)MobCategory.MISC).m_20712_(name.toString());
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"of({ _, level -> factory\u2026C).build(name.toString())");
        return entityType;
    }

    @Override
    @NotNull
    public CreativeModeTab.Builder createTabBuilder() {
        CreativeModeTab.Builder builder = CreativeModeTab.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
        return builder;
    }

    @Override
    @NotNull
    public List<ItemStack> createTurtlesWithUpgrade(@NotNull UpgradeData<ITurtleUpgrade> upgrade) {
        Intrinsics.checkNotNullParameter(upgrade, (String)"upgrade");
        Object[] objectArray = new ItemStack[]{((TurtleItem)ModRegistry.Items.TURTLE_NORMAL.get()).create(-1, null, -1, null, upgrade, 0, null), ((TurtleItem)ModRegistry.Items.TURTLE_ADVANCED.get()).create(-1, null, -1, null, upgrade, 0, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<ItemStack> createPocketsWithUpgrade(@NotNull UpgradeData<IPocketUpgrade> upgrade) {
        Intrinsics.checkNotNullParameter(upgrade, (String)"upgrade");
        Object[] objectArray = new ItemStack[]{((PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()).create(-1, null, -1, upgrade), ((PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get()).create(-1, null, -1, upgrade)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean isOre(@NotNull BlockState block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return block.m_204336_(Tags.Blocks.ORES);
    }

    @Override
    public void triggerRenderUpdate(@NotNull BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Level level = blockEntity.m_58904_();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        if (level2.f_46443_) {
            BlockPos pos = blockEntity.m_58899_();
            Minecraft.m_91087_().f_91060_.m_109494_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            blockEntity.requestModelDataUpdate();
        }
    }

    private static final void getPeripheral$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    private static final BlockEntity createBlockEntityType$lambda$1(BiFunction $factory, BlockPos t, BlockState u) {
        Intrinsics.checkNotNullParameter((Object)$factory, (String)"$factory");
        BlockPos blockPos = t;
        Intrinsics.checkNotNull((Object)blockPos);
        BlockState blockState = u;
        Intrinsics.checkNotNull((Object)blockState);
        return (BlockEntity)$factory.apply(blockPos, blockState);
    }

    private static final Entity createEntityType$lambda$2(Function $factory, EntityType entityType, Level level) {
        Intrinsics.checkNotNullParameter((Object)$factory, (String)"$factory");
        return (Entity)$factory.apply(level);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ#\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0096\u0002J\u0015\u0010\b\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0011J#\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00120\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0096\u0002J\u0015\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0096\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dH\u0016J\u0017\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lsite/siredvin/peripheralium/forge/ForgePeripheraliumPlatform$ForgeRegistryWrapper;", "T", "Lsite/siredvin/peripheralium/xplat/RegistryWrapper;", "name", "Lnet/minecraft/resources/ResourceLocation;", "registry", "Lnet/minecraftforge/registries/ForgeRegistry;", "(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraftforge/registries/ForgeRegistry;)V", "get", "id", "", "(I)Ljava/lang/Object;", "Ljava/util/Optional;", "Lnet/minecraft/core/Holder$Reference;", "resourceKey", "Lnet/minecraft/resources/ResourceKey;", "location", "(Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/Object;", "Lnet/minecraft/core/HolderSet$Named;", "tagKey", "Lnet/minecraft/tags/TagKey;", "getId", "something", "(Ljava/lang/Object;)I", "getKey", "(Ljava/lang/Object;)Lnet/minecraft/resources/ResourceLocation;", "iterator", "", "keySet", "", "tryGet", "peripheralium-forge-1.20.1"})
    private static final class ForgeRegistryWrapper<T>
    implements RegistryWrapper<T> {
        @NotNull
        private final ResourceLocation name;
        @NotNull
        private final ForgeRegistry<T> registry;

        public ForgeRegistryWrapper(@NotNull ResourceLocation name, @NotNull ForgeRegistry<T> registry) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(registry, (String)"registry");
            this.name = name;
            this.registry = registry;
        }

        @Override
        public int getId(T something) {
            int id = this.registry.getID(something);
            if (id == -1) {
                throw new IllegalArgumentException();
            }
            return id;
        }

        @Override
        @NotNull
        public ResourceLocation getKey(T something) {
            ResourceLocation resourceLocation = this.registry.getKey(something);
            if (resourceLocation == null) {
                throw new IllegalArgumentException();
            }
            return resourceLocation;
        }

        @Override
        public T get(@NotNull ResourceLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Object object = this.registry.getValue(location);
            if (object == null) {
                throw new IllegalArgumentException();
            }
            return (T)object;
        }

        @Override
        public T get(int id) {
            Object object = this.registry.getValue(id);
            if (object == null) {
                throw new IllegalArgumentException();
            }
            return (T)object;
        }

        @NotNull
        public Optional<HolderSet.Named<T>> m_254901_(@NotNull TagKey<T> tagKey) {
            Intrinsics.checkNotNullParameter(tagKey, (String)"tagKey");
            Optional<HolderSet.Named<T>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
            return optional;
        }

        @NotNull
        public Optional<Holder.Reference<T>> m_254902_(@NotNull ResourceKey<T> resourceKey) {
            Intrinsics.checkNotNullParameter(resourceKey, (String)"resourceKey");
            Optional optional = this.registry.getDelegate(resourceKey);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"registry.getDelegate(resourceKey)");
            return optional;
        }

        @Override
        @Nullable
        public T tryGet(@NotNull ResourceLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            return (T)this.registry.getValue(location);
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            Iterator iterator = this.registry.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"registry.iterator()");
            return iterator;
        }

        @Override
        @NotNull
        public Set<ResourceLocation> keySet() {
            Set set = this.registry.getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"registry.keys");
            return set;
        }
    }
}

