/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.extra.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.storages.fluid.FluidSink;
import site.siredvin.peripheralium.storages.fluid.FluidStack;
import site.siredvin.peripheralium.storages.fluid.FluidStorage;
import site.siredvin.peripheralium.storages.fluid.FluidStorageExtractor;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;
import site.siredvin.peripheralium.xplat.XplatRegistries;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010$\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J4\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u0018H\u0007J4\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u0018H\u0007J\u0018\u0010\u001d\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\u001f0\u001eH\u0007R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lsite/siredvin/peripheralium/extra/plugins/FluidStoragePlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "storage", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "fluidStorageTransferLimit", "", "(Lnet/minecraft/world/level/Level;Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;I)V", "additionalType", "", "getAdditionalType", "()Ljava/lang/String;", "fluidInformation", "", "", "fluid", "Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "pullFluid", "", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "fromName", "limit", "Ljava/util/Optional;", "", "fluidName", "pushFluid", "toName", "tanks", "", "", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nFluidStoragePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FluidStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/FluidStoragePlugin\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,78:1\n32#2,2:79\n*S KotlinDebug\n*F\n+ 1 FluidStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/FluidStoragePlugin\n*L\n30#1:79,2\n*E\n"})
public class FluidStoragePlugin
implements IPeripheralPlugin {
    @NotNull
    private final Level level;
    @NotNull
    private final FluidStorage storage;
    private final int fluidStorageTransferLimit;

    public FluidStoragePlugin(@NotNull Level level, @NotNull FluidStorage storage2, int fluidStorageTransferLimit) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        this.level = level;
        this.storage = storage2;
        this.fluidStorageTransferLimit = fluidStorageTransferLimit;
    }

    @Override
    @NotNull
    public String getAdditionalType() {
        return "fluid_storage";
    }

    @NotNull
    protected Map<String, Object> fluidInformation(@NotNull FluidStack fluid) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        return LuaRepresentation.INSTANCE.forFluidStack(fluid);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> tanks() {
        List data = new ArrayList();
        Iterator<FluidStack> $this$forEach$iv = this.storage.getFluids();
        boolean $i$f$forEach = false;
        Iterator<FluidStack> iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            FluidStack element$iv;
            FluidStack it = element$iv = iterator.next();
            boolean bl = false;
            data.add(this.fluidInformation(it));
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    public final double pushFluid(@NotNull IComputerAccess computer, @NotNull String toName, @NotNull Optional<Long> limit, @NotNull Optional<String> fluidName) {
        Predicate<FluidStack> predicate;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(fluidName, (String)"fluidName");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        FluidSink fluidSink = FluidStorageExtractor.INSTANCE.extractFluidSinkFromUnknown(this.level, location.getTarget());
        if (fluidSink == null) {
            throw new LuaException("Target '" + toName + "' is not an fluid inventory");
        }
        FluidSink toStorage = fluidSink;
        if (fluidName.isEmpty()) {
            predicate = FluidStoragePlugin::pushFluid$lambda$1;
        } else {
            Fluid fluid = XplatRegistries.INSTANCE.getFLUIDS().get(new ResourceLocation(fluidName.get()));
            if (fluid.m_6212_(Fluids.f_76191_)) {
                throw new LuaException("There is no fluid " + fluidName.get());
            }
            predicate = arg_0 -> FluidStoragePlugin.pushFluid$lambda$2(fluid, arg_0);
        }
        Predicate<FluidStack> predicate2 = predicate;
        long l = this.fluidStorageTransferLimit;
        Long l2 = limit.orElse(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"limit.orElse(Long.MAX_VALUE)");
        long l3 = ((Number)l2).longValue();
        long realLimit = Math.min(l, l3);
        return this.storage.moveTo(toStorage, realLimit, predicate2);
    }

    @LuaFunction(mainThread=true)
    public final double pullFluid(@NotNull IComputerAccess computer, @NotNull String fromName, @NotNull Optional<Long> limit, @NotNull Optional<String> fluidName) {
        Predicate<FluidStack> predicate;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(fluidName, (String)"fluidName");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        FluidStorage fluidStorage = FluidStorageExtractor.INSTANCE.extractFluidStorageFromUnknown(this.level, location.getTarget());
        if (fluidStorage == null) {
            throw new LuaException("Target '" + fromName + "' is not an fluid inventory");
        }
        FluidStorage fromStorage = fluidStorage;
        if (fluidName.isEmpty()) {
            predicate = FluidStoragePlugin::pullFluid$lambda$3;
        } else {
            Fluid fluid = XplatRegistries.INSTANCE.getFLUIDS().get(new ResourceLocation(fluidName.get()));
            if (fluid.m_6212_(Fluids.f_76191_)) {
                throw new LuaException("There is no fluid " + fluidName.get());
            }
            predicate = arg_0 -> FluidStoragePlugin.pullFluid$lambda$4(fluid, arg_0);
        }
        Predicate<FluidStack> predicate2 = predicate;
        long l = this.fluidStorageTransferLimit;
        Long l2 = limit.orElse(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"limit.orElse(Long.MAX_VALUE)");
        long l3 = ((Number)l2).longValue();
        long realLimit = Math.min(l, l3);
        return this.storage.moveFrom(fromStorage, realLimit, predicate2);
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods(this, server);
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }

    private static final boolean pushFluid$lambda$1(FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pushFluid$lambda$2(Fluid $fluid, FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFluid().m_6212_($fluid);
    }

    private static final boolean pullFluid$lambda$3(FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pullFluid$lambda$4(Fluid $fluid, FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFluid().m_6212_($fluid);
    }
}

