/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.extra.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.extra.plugins.PeripheralPluginUtils;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.ItemStorageExtractor;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00150\u0014H\u0007J\u0018\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00170\u0014H\u0016J0\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001fH\u0007J0\u0010 \u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001fH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lsite/siredvin/peripheralium/extra/plugins/AbstractItemStoragePlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "()V", "additionalType", "", "getAdditionalType", "()Ljava/lang/String;", "itemStorageTransferLimit", "", "getItemStorageTransferLimit", "()I", "level", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "storage", "Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "getStorage", "()Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "items", "", "", "itemsImpl", "", "pullItem", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "fromName", "itemQuery", "", "limit", "Ljava/util/Optional;", "pushItem", "toName", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nAbstractItemStoragePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractItemStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/AbstractItemStoragePlugin\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,66:1\n32#2,2:67\n*S KotlinDebug\n*F\n+ 1 AbstractItemStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/AbstractItemStoragePlugin\n*L\n27#1:67,2\n*E\n"})
public abstract class AbstractItemStoragePlugin
implements IPeripheralPlugin {
    @NotNull
    public abstract ItemStorage getStorage();

    @NotNull
    public abstract Level getLevel();

    public abstract int getItemStorageTransferLimit();

    @Override
    @NotNull
    public String getAdditionalType() {
        return "item_storage";
    }

    @NotNull
    public List<Map<String, ?>> itemsImpl() {
        List result = new ArrayList();
        Iterator<ItemStack> $this$forEach$iv = this.getStorage().getItems();
        boolean $i$f$forEach = false;
        Iterator<ItemStack> iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            ItemStack element$iv;
            ItemStack it = element$iv = iterator.next();
            boolean bl = false;
            if (it.m_41619_()) continue;
            result.add(LuaRepresentation.forItemStack$default(LuaRepresentation.INSTANCE, it, null, 2, null));
        }
        return result;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> items() {
        return this.itemsImpl();
    }

    @LuaFunction(mainThread=true)
    public final int pushItem(@NotNull IComputerAccess computer, @NotNull String toName, @Nullable Object itemQuery, @NotNull Optional<Integer> limit) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        ItemSink itemSink = ItemStorageExtractor.INSTANCE.extractItemSinkFromUnknown(this.getLevel(), location.getTarget());
        if (itemSink == null) {
            throw new LuaException("Target '" + toName + "' is not an targetable storage");
        }
        ItemSink toStorage = itemSink;
        Predicate<ItemStack> predicate = PeripheralPluginUtils.INSTANCE.itemQueryToPredicate(itemQuery);
        int n = this.getItemStorageTransferLimit();
        Integer n2 = limit.orElse(Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"limit.orElse(Int.MAX_VALUE)");
        int n3 = ((Number)n2).intValue();
        int realLimit = Math.min(n, n3);
        return ItemStorage.DefaultImpls.moveTo$default(this.getStorage(), toStorage, realLimit, 0, predicate, 4, null);
    }

    @LuaFunction(mainThread=true)
    public final int pullItem(@NotNull IComputerAccess computer, @NotNull String fromName, @Nullable Object itemQuery, @NotNull Optional<Integer> limit) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        ItemStorage itemStorage = ItemStorageExtractor.INSTANCE.extractStorageFromUnknown(this.getLevel(), location.getTarget());
        if (itemStorage == null) {
            throw new LuaException("Target '" + fromName + "' is not an storage");
        }
        ItemStorage fromStorage = itemStorage;
        Predicate<ItemStack> predicate = PeripheralPluginUtils.INSTANCE.itemQueryToPredicate(itemQuery);
        int n = this.getItemStorageTransferLimit();
        Integer n2 = limit.orElse(Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"limit.orElse(Int.MAX_VALUE)");
        int n3 = ((Number)n2).intValue();
        int realLimit = Math.min(n, n3);
        return ItemSink.DefaultImpls.moveFrom$default(this.getStorage(), fromStorage, realLimit, 0, predicate, 4, null);
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods(this, server);
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }
}

