/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.data.blocks;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Direction;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.xplat.XplatRegistries;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a/\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\r\"\u00020\u000b\u00a2\u0006\u0002\u0010\u000e\u001a/\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\r\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0011\u001a\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\"\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u001aF\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u000b\u001a\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!\u001a,\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u000b\u001a,\u0010\"\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u000b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006&"}, d2={"TURTLE_LEFT_UPGRADE", "Lnet/minecraft/data/models/model/ModelTemplate;", "getTURTLE_LEFT_UPGRADE", "()Lnet/minecraft/data/models/model/ModelTemplate;", "TURTLE_RIGHT_UPGRADE", "getTURTLE_RIGHT_UPGRADE", "createFlatItem", "", "generators", "Lnet/minecraft/data/models/ItemModelGenerators;", "model", "Lnet/minecraft/resources/ResourceLocation;", "textures", "", "(Lnet/minecraft/data/models/ItemModelGenerators;Lnet/minecraft/resources/ResourceLocation;[Lnet/minecraft/resources/ResourceLocation;)V", "item", "Lnet/minecraft/world/item/Item;", "(Lnet/minecraft/data/models/ItemModelGenerators;Lnet/minecraft/world/item/Item;[Lnet/minecraft/resources/ResourceLocation;)V", "createHorizontalFacingDispatch", "Lnet/minecraft/data/models/blockstates/PropertyDispatch;", "genericBlock", "Lnet/minecraft/data/models/BlockModelGenerators;", "block", "Lnet/minecraft/world/level/block/Block;", "horizontalOrientatedBlock", "horizontalOrientedModel", "overwriteSide", "overwriteTop", "overwriteBottom", "overwriteFront", "toYAngle", "Lnet/minecraft/data/models/blockstates/VariantProperties$Rotation;", "direction", "Lnet/minecraft/core/Direction;", "turtleUpgrades", "textureSuffix", "", "baseID", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Helpers.kt\nsite/siredvin/peripheralium/data/blocks/HelpersKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,179:1\n13644#2,3:180\n*S KotlinDebug\n*F\n+ 1 Helpers.kt\nsite/siredvin/peripheralium/data/blocks/HelpersKt\n*L\n54#1:180,3\n*E\n"})
public final class HelpersKt {
    @NotNull
    private static final ModelTemplate TURTLE_LEFT_UPGRADE;
    @NotNull
    private static final ModelTemplate TURTLE_RIGHT_UPGRADE;

    @NotNull
    public static final ModelTemplate getTURTLE_LEFT_UPGRADE() {
        return TURTLE_LEFT_UPGRADE;
    }

    @NotNull
    public static final ModelTemplate getTURTLE_RIGHT_UPGRADE() {
        return TURTLE_RIGHT_UPGRADE;
    }

    public static final void createFlatItem(@NotNull ItemModelGenerators generators, @NotNull Item item, ResourceLocation ... textures) {
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)textures, (String)"textures");
        ResourceLocation resourceLocation = ModelLocationUtils.m_125571_((Item)item);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getModelLocation(item)");
        HelpersKt.createFlatItem(generators, resourceLocation, Arrays.copyOf(textures, textures.length));
    }

    /*
     * WARNING - void declaration
     */
    public static final void createFlatItem(@NotNull ItemModelGenerators generators, @NotNull ResourceLocation model, ResourceLocation ... textures) {
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)textures, (String)"textures");
        if (textures.length > 5) {
            throw new IndexOutOfBoundsException("Too many layers");
        }
        if (textures.length == 0) {
            throw new IndexOutOfBoundsException("Must have at least one texture");
        }
        if (textures.length == 1) {
            ModelTemplates.f_125658_.m_125612_(model, TextureMapping.m_125820_((ResourceLocation)textures[0]), generators.f_125080_);
            return;
        }
        int n = 0;
        int n2 = textures.length;
        TextureSlot[] textureSlotArray = new TextureSlot[n2];
        while (n < n2) {
            int n3 = n++;
            textureSlotArray[n3] = TextureSlot.m_125898_((String)("layer" + n3));
        }
        TextureSlot[] slots = textureSlotArray;
        TextureMapping mapping = new TextureMapping();
        TextureSlot[] $this$forEachIndexed$iv = slots;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (TextureSlot item$iv : $this$forEachIndexed$iv) {
            void textureSlot;
            int n4 = index$iv++;
            TextureSlot textureSlot2 = item$iv;
            int index = n4;
            boolean bl = false;
            mapping.m_125758_((TextureSlot)textureSlot, textures[index]);
        }
        new ModelTemplate(Optional.of(new ResourceLocation("item/generated")), Optional.empty(), Arrays.copyOf(slots, slots.length)).m_125612_(model, mapping, generators.f_125080_);
    }

    @NotNull
    public static final VariantProperties.Rotation toYAngle(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> VariantProperties.Rotation.R0;
            case 2 -> VariantProperties.Rotation.R180;
            case 3 -> VariantProperties.Rotation.R90;
            case 4 -> VariantProperties.Rotation.R270;
            default -> VariantProperties.Rotation.R270;
        };
    }

    @NotNull
    public static final PropertyDispatch createHorizontalFacingDispatch() {
        PropertyDispatch.C1 dispatch = PropertyDispatch.m_125294_((Property)((Property)BlockStateProperties.f_61374_));
        for (Direction direction : BlockStateProperties.f_61374_.m_6908_()) {
            Comparable comparable = (Comparable)direction;
            Variant variant = Variant.m_125501_();
            Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"direction");
            dispatch.m_125329_(comparable, variant.m_125511_(VariantProperties.f_125519_, (Object)HelpersKt.toYAngle(direction)));
        }
        Intrinsics.checkNotNullExpressionValue((Object)dispatch, (String)"dispatch");
        return (PropertyDispatch)dispatch;
    }

    public static final void genericBlock(@NotNull BlockModelGenerators generators, @NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        ResourceLocation model = ModelTemplates.f_125692_.m_125592_(block, TextureMapping.m_125748_((Block)block).m_125758_(TextureSlot.f_125867_, TextureMapping.m_125740_((Block)block)), generators.f_124478_);
        generators.f_124477_.accept(MultiVariantGenerator.m_125256_((Block)block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model)));
        generators.m_124797_(block, ModelLocationUtils.m_125576_((Block)block));
    }

    @NotNull
    public static final ResourceLocation horizontalOrientedModel(@NotNull BlockModelGenerators generators, @NotNull Block block, @Nullable ResourceLocation overwriteSide, @Nullable ResourceLocation overwriteTop, @Nullable ResourceLocation overwriteBottom, @Nullable ResourceLocation overwriteFront) {
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        TextureMapping textureMapping = TextureMapping.m_125846_((Block)block);
        if (overwriteSide != null) {
            textureMapping.m_125758_(TextureSlot.f_125875_, overwriteSide);
        }
        if (overwriteBottom != null) {
            textureMapping.m_125758_(TextureSlot.f_125871_, overwriteBottom);
        }
        if (overwriteTop != null) {
            textureMapping.m_125758_(TextureSlot.f_125872_, overwriteTop);
        }
        if (overwriteFront != null) {
            textureMapping.m_125758_(TextureSlot.f_125873_, overwriteFront);
        }
        ResourceLocation resourceLocation = ModelTemplates.f_125698_.m_125592_(block, textureMapping, generators.f_124478_);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"CUBE_ORIENTABLE.create(\n\u2026rators.modelOutput,\n    )");
        return resourceLocation;
    }

    public static /* synthetic */ ResourceLocation horizontalOrientedModel$default(BlockModelGenerators blockModelGenerators, Block block, ResourceLocation resourceLocation, ResourceLocation resourceLocation2, ResourceLocation resourceLocation3, ResourceLocation resourceLocation4, int n, Object object) {
        if ((n & 4) != 0) {
            resourceLocation = null;
        }
        if ((n & 8) != 0) {
            resourceLocation2 = null;
        }
        if ((n & 0x10) != 0) {
            resourceLocation3 = null;
        }
        if ((n & 0x20) != 0) {
            resourceLocation4 = null;
        }
        return HelpersKt.horizontalOrientedModel(blockModelGenerators, block, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4);
    }

    public static final void horizontalOrientatedBlock(@NotNull BlockModelGenerators generators, @NotNull Block block, @Nullable ResourceLocation model) {
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Consumer consumer = generators.f_124477_;
        Variant variant = Variant.m_125501_();
        ResourceLocation resourceLocation = model;
        if (resourceLocation == null) {
            resourceLocation = ModelLocationUtils.m_125576_((Block)block);
        }
        consumer.accept(MultiVariantGenerator.m_125256_((Block)block, (Variant)variant.m_125511_(VariantProperties.f_125520_, (Object)resourceLocation)).m_125271_(HelpersKt.createHorizontalFacingDispatch()));
        generators.m_124797_(block, ModelLocationUtils.m_125576_((Block)block));
    }

    public static /* synthetic */ void horizontalOrientatedBlock$default(BlockModelGenerators blockModelGenerators, Block block, ResourceLocation resourceLocation, int n, Object object) {
        if ((n & 4) != 0) {
            resourceLocation = null;
        }
        HelpersKt.horizontalOrientatedBlock(blockModelGenerators, block, resourceLocation);
    }

    public static final void turtleUpgrades(@NotNull ItemModelGenerators generators, @NotNull Block block, @NotNull String textureSuffix, @Nullable ResourceLocation baseID) {
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)textureSuffix, (String)"textureSuffix");
        ResourceLocation resourceLocation = baseID;
        if (resourceLocation == null) {
            resourceLocation = XplatRegistries.INSTANCE.getBLOCKS().getKey(block).m_246208_("turtle/");
        }
        ResourceLocation realBaseID = resourceLocation;
        TURTLE_RIGHT_UPGRADE.m_125612_(realBaseID.m_266382_("_right"), new TextureMapping().m_125758_(TextureSlot.f_125868_, TextureMapping.m_125740_((Block)block).m_266382_(textureSuffix)), generators.f_125080_);
        TURTLE_LEFT_UPGRADE.m_125612_(realBaseID.m_266382_("_left"), new TextureMapping().m_125758_(TextureSlot.f_125868_, TextureMapping.m_125740_((Block)block).m_266382_(textureSuffix)), generators.f_125080_);
    }

    public static /* synthetic */ void turtleUpgrades$default(ItemModelGenerators itemModelGenerators, Block block, String string, ResourceLocation resourceLocation, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        if ((n & 8) != 0) {
            resourceLocation = null;
        }
        HelpersKt.turtleUpgrades(itemModelGenerators, block, string, resourceLocation);
    }

    public static final void turtleUpgrades(@NotNull ItemModelGenerators generators, @NotNull Item item, @NotNull String textureSuffix, @Nullable ResourceLocation baseID) {
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)textureSuffix, (String)"textureSuffix");
        ResourceLocation resourceLocation = baseID;
        if (resourceLocation == null) {
            resourceLocation = XplatRegistries.INSTANCE.getITEMS().getKey(item).m_246208_("turtle/");
        }
        ResourceLocation realBaseID = resourceLocation;
        TURTLE_RIGHT_UPGRADE.m_125612_(realBaseID.m_266382_("_right"), new TextureMapping().m_125758_(TextureSlot.f_125868_, TextureMapping.m_125778_((Item)item).m_266382_(textureSuffix)), generators.f_125080_);
        TURTLE_LEFT_UPGRADE.m_125612_(realBaseID.m_266382_("_left"), new TextureMapping().m_125758_(TextureSlot.f_125868_, TextureMapping.m_125778_((Item)item).m_266382_(textureSuffix)), generators.f_125080_);
    }

    public static /* synthetic */ void turtleUpgrades$default(ItemModelGenerators itemModelGenerators, Item item, String string, ResourceLocation resourceLocation, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        if ((n & 8) != 0) {
            resourceLocation = null;
        }
        HelpersKt.turtleUpgrades(itemModelGenerators, item, string, resourceLocation);
    }

    static {
        TextureSlot[] textureSlotArray = new TextureSlot[]{TextureSlot.f_125868_};
        TURTLE_LEFT_UPGRADE = new ModelTemplate(Optional.of(new ResourceLocation("peripheralium", "base/upgrade_base_left")), Optional.empty(), textureSlotArray);
        textureSlotArray = new TextureSlot[]{TextureSlot.f_125868_};
        TURTLE_RIGHT_UPGRADE = new ModelTemplate(Optional.of(new ResourceLocation("peripheralium", "base/upgrade_base_right")), Optional.empty(), textureSlotArray);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

