/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.computercraft.peripheral.owner;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.PeripheralOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.TurtleFuelAbility;
import site.siredvin.peripheralium.computercraft.peripheral.owner.BasePeripheralOwner;
import site.siredvin.peripheralium.storages.ContainerUtils;
import site.siredvin.peripheralium.storages.ContainerWrapper;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;
import site.siredvin.peripheralium.util.DataStorageUtil;
import site.siredvin.peripheralium.util.world.FakePlayerProviderTurtle;
import site.siredvin.peripheralium.util.world.FakePlayerProxy;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010+\u001a\u00020\u00002\b\b\u0002\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u0002012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u00102\u001a\u00020/H\u0016J\u0018\u00103\u001a\u0002012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020&H\u0016J9\u00106\u001a\u0002H7\"\u0004\b\u0000\u001072\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u0002H7092\b\u0010;\u001a\u0004\u0018\u00010\f2\u0006\u0010<\u001a\u000201H\u0016\u00a2\u0006\u0002\u0010=R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006>"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/owner/TurtlePeripheralOwner;", "Lsite/siredvin/peripheralium/computercraft/peripheral/owner/BasePeripheralOwner;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;)V", "dataStorage", "Lnet/minecraft/nbt/CompoundTag;", "getDataStorage", "()Lnet/minecraft/nbt/CompoundTag;", "facing", "Lnet/minecraft/core/Direction;", "getFacing", "()Lnet/minecraft/core/Direction;", "level", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "owner", "Lnet/minecraft/world/entity/player/Player;", "getOwner", "()Lnet/minecraft/world/entity/player/Player;", "pos", "Lnet/minecraft/core/BlockPos;", "getPos", "()Lnet/minecraft/core/BlockPos;", "getSide", "()Ldan200/computercraft/api/turtle/TurtleSide;", "storage", "Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "getStorage", "()Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "targetRepresentation", "", "getTargetRepresentation", "()Ljava/lang/Object;", "toolInMainHand", "Lnet/minecraft/world/item/ItemStack;", "getToolInMainHand", "()Lnet/minecraft/world/item/ItemStack;", "getTurtle", "()Ldan200/computercraft/api/turtle/ITurtleAccess;", "attachFuel", "maxFuelConsumptionLevel", "", "destroyUpgrade", "", "isMovementPossible", "", "markDataStorageDirty", "move", "storeItem", "stored", "withPlayer", "T", "function", "Lkotlin/Function1;", "Lsite/siredvin/peripheralium/util/world/FakePlayerProxy;", "overwrittenDirection", "skipInventory", "(Lkotlin/jvm/functions/Function1;Lnet/minecraft/core/Direction;Z)Ljava/lang/Object;", "peripheralium-forge-1.20.1"})
public final class TurtlePeripheralOwner
extends BasePeripheralOwner {
    @NotNull
    private final ITurtleAccess turtle;
    @NotNull
    private final TurtleSide side;

    public TurtlePeripheralOwner(@NotNull ITurtleAccess turtle, @NotNull TurtleSide side) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        this.turtle = turtle;
        this.side = side;
    }

    @NotNull
    public final ITurtleAccess getTurtle() {
        return this.turtle;
    }

    @NotNull
    public final TurtleSide getSide() {
        return this.side;
    }

    @Override
    @Nullable
    public Level getLevel() {
        return this.turtle.getLevel();
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        BlockPos blockPos = this.turtle.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"turtle.position");
        return blockPos;
    }

    @Override
    @NotNull
    public Direction getFacing() {
        Direction direction = this.turtle.getDirection();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"turtle.direction");
        return direction;
    }

    @Override
    @NotNull
    public Object getTargetRepresentation() {
        return this.turtle;
    }

    @Override
    @Nullable
    public Player getOwner() {
        GameProfile gameProfile = this.turtle.getOwningPlayer();
        if (gameProfile == null) {
            return null;
        }
        GameProfile owningPlayer = gameProfile;
        return this.turtle.getLevel().m_46003_(owningPlayer.getId());
    }

    @Override
    @NotNull
    public CompoundTag getDataStorage() {
        return DataStorageUtil.INSTANCE.getDataStorage(this.turtle, this.side);
    }

    @Override
    @NotNull
    public SlottedItemStorage getStorage() {
        Container container = this.turtle.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"turtle.inventory");
        return new ContainerWrapper(container);
    }

    @Override
    public void markDataStorageDirty() {
        this.turtle.updateUpgradeNBTData(this.side);
    }

    @Override
    public <T> T withPlayer(@NotNull Function1<? super FakePlayerProxy, ? extends T> function, @Nullable Direction overwrittenDirection, boolean skipInventory) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        return (T)FakePlayerProviderTurtle.INSTANCE.withPlayer(this.turtle, arg_0 -> TurtlePeripheralOwner.withPlayer$lambda$0(function, arg_0), overwrittenDirection, skipInventory);
    }

    @Override
    @NotNull
    public ItemStack getToolInMainHand() {
        ItemStack itemStack = this.turtle.getInventory().m_8020_(this.turtle.getSelectedSlot());
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"turtle.inventory.getItem(turtle.selectedSlot)");
        return itemStack;
    }

    @Override
    @NotNull
    public ItemStack storeItem(@NotNull ItemStack stored) {
        Intrinsics.checkNotNullParameter((Object)stored, (String)"stored");
        Container container = this.turtle.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"turtle.inventory");
        ItemStack remainder = ContainerUtils.storeItem$default(ContainerUtils.INSTANCE, container, stored, this.turtle.getSelectedSlot(), 0, 8, null);
        if (!remainder.m_41619_() && this.turtle.getSelectedSlot() > 1) {
            Container container2 = this.turtle.getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)container2, (String)"turtle.inventory");
            return ContainerUtils.INSTANCE.storeItem(container2, remainder, 0, this.turtle.getSelectedSlot() - 1);
        }
        return remainder;
    }

    @Override
    public void destroyUpgrade() {
        this.turtle.setUpgrade(this.side, null);
    }

    @Override
    public boolean isMovementPossible(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return (Boolean)FakePlayerProviderTurtle.withPlayer$default(FakePlayerProviderTurtle.INSTANCE, this.turtle, arg_0 -> TurtlePeripheralOwner.isMovementPossible$lambda$1(level, pos, arg_0), null, false, 12, null);
    }

    @Override
    public boolean move(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.turtle.teleportTo(level, pos);
    }

    @NotNull
    public final TurtlePeripheralOwner attachFuel(int maxFuelConsumptionLevel) {
        this.attachAbility(PeripheralOwnerAbility.Companion.getFUEL(), (IOwnerAbility)new TurtleFuelAbility(this, maxFuelConsumptionLevel));
        return this;
    }

    public static /* synthetic */ TurtlePeripheralOwner attachFuel$default(TurtlePeripheralOwner turtlePeripheralOwner, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return turtlePeripheralOwner.attachFuel(n);
    }

    private static final Object withPlayer$lambda$0(Function1 $tmp0, FakePlayerProxy p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return $tmp0.invoke((Object)p0);
    }

    private static final Boolean isMovementPossible$lambda$1(Level $level, BlockPos $pos, FakePlayerProxy fakePlayerProxy) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)fakePlayerProxy, (String)"<anonymous parameter 0>");
        if ($level.m_151570_($pos)) {
            return false;
        }
        if (!$level.m_46739_($pos)) {
            return false;
        }
        if (!$level.m_46749_($pos)) {
            return false;
        }
        return $level.m_6857_().m_61937_($pos);
    }
}

