/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.computercraft.peripheral.owner;

import java.util.Objects;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.blockentities.IOwnedBlockEntity;
import site.siredvin.peripheralium.api.peripheral.IPeripheralTileEntity;
import site.siredvin.peripheralium.common.blocks.GenericBlockEntityBlock;
import site.siredvin.peripheralium.computercraft.peripheral.owner.BasePeripheralOwner;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.ItemStorageExtractor;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;
import site.siredvin.peripheralium.util.DataStorageUtil;
import site.siredvin.peripheralium.util.world.FakePlayerProviderBlockEntity;
import site.siredvin.peripheralium.util.world.FakePlayerProxy;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010/\u001a\u00020,H\u0016J\u0018\u00100\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020(H\u0016J9\u00103\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u00012\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u0002H\u0001052\b\u00107\u001a\u0004\u0018\u00010\u000e2\u0006\u00108\u001a\u00020.H\u0016\u00a2\u0006\u0002\u00109R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 R\u0014\u0010#\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006:"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/owner/BlockEntityPeripheralOwner;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralTileEntity;", "Lsite/siredvin/peripheralium/computercraft/peripheral/owner/BasePeripheralOwner;", "tileEntity", "facingProperty", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "(Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/level/block/state/properties/DirectionProperty;)V", "dataStorage", "Lnet/minecraft/nbt/CompoundTag;", "getDataStorage", "()Lnet/minecraft/nbt/CompoundTag;", "facing", "Lnet/minecraft/core/Direction;", "getFacing", "()Lnet/minecraft/core/Direction;", "level", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "owner", "Lnet/minecraft/world/entity/player/Player;", "getOwner", "()Lnet/minecraft/world/entity/player/Player;", "pos", "Lnet/minecraft/core/BlockPos;", "getPos", "()Lnet/minecraft/core/BlockPos;", "storage", "Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "getStorage", "()Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "storage$delegate", "Lkotlin/Lazy;", "targetRepresentation", "getTargetRepresentation", "()Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "toolInMainHand", "Lnet/minecraft/world/item/ItemStack;", "getToolInMainHand", "()Lnet/minecraft/world/item/ItemStack;", "destroyUpgrade", "", "isMovementPossible", "", "markDataStorageDirty", "move", "storeItem", "stored", "withPlayer", "function", "Lkotlin/Function1;", "Lsite/siredvin/peripheralium/util/world/FakePlayerProxy;", "overwrittenDirection", "skipInventory", "(Lkotlin/jvm/functions/Function1;Lnet/minecraft/core/Direction;Z)Ljava/lang/Object;", "peripheralium-forge-1.20.1"})
public final class BlockEntityPeripheralOwner<T extends BlockEntity>
extends BasePeripheralOwner {
    @NotNull
    private final T tileEntity;
    @NotNull
    private final DirectionProperty facingProperty;
    @NotNull
    private final Lazy storage$delegate;

    public BlockEntityPeripheralOwner(@NotNull T tileEntity, @NotNull DirectionProperty facingProperty) {
        Intrinsics.checkNotNullParameter(tileEntity, (String)"tileEntity");
        Intrinsics.checkNotNullParameter((Object)facingProperty, (String)"facingProperty");
        this.tileEntity = tileEntity;
        this.facingProperty = facingProperty;
        this.storage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SlottedItemStorage>(this){
            final /* synthetic */ BlockEntityPeripheralOwner<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SlottedItemStorage invoke() {
                Level level = BlockEntityPeripheralOwner.access$getTileEntity$p(this.this$0).m_58904_();
                Intrinsics.checkNotNull((Object)level);
                BlockPos blockPos = BlockEntityPeripheralOwner.access$getTileEntity$p(this.this$0).m_58899_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"tileEntity.blockPos");
                ItemStorage itemStorage = ItemStorageExtractor.INSTANCE.extractStorage(level, blockPos, BlockEntityPeripheralOwner.access$getTileEntity$p(this.this$0));
                return itemStorage instanceof SlottedItemStorage ? (SlottedItemStorage)itemStorage : null;
            }
        }));
    }

    public /* synthetic */ BlockEntityPeripheralOwner(BlockEntity blockEntity, DirectionProperty directionProperty, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            directionProperty = GenericBlockEntityBlock.Companion.getFACING();
        }
        this(blockEntity, directionProperty);
    }

    @Override
    @Nullable
    public Level getLevel() {
        return Objects.requireNonNull(this.tileEntity.m_58904_());
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        BlockPos blockPos = this.tileEntity.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"tileEntity.blockPos");
        return blockPos;
    }

    @NotNull
    public T getTargetRepresentation() {
        return this.tileEntity;
    }

    @Override
    @NotNull
    public Direction getFacing() {
        Comparable comparable = this.tileEntity.m_58900_().m_61143_((Property)this.facingProperty);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tileEntity.blockState.getValue(facingProperty)");
        return (Direction)comparable;
    }

    @Override
    @Nullable
    public Player getOwner() {
        T t = this.tileEntity;
        IOwnedBlockEntity iOwnedBlockEntity = t instanceof IOwnedBlockEntity ? (IOwnedBlockEntity)t : null;
        return iOwnedBlockEntity != null ? iOwnedBlockEntity.getPlayer() : null;
    }

    @Override
    @NotNull
    public CompoundTag getDataStorage() {
        return DataStorageUtil.INSTANCE.getDataStorage((IPeripheralTileEntity)this.tileEntity);
    }

    @Override
    @Nullable
    public SlottedItemStorage getStorage() {
        Lazy lazy = this.storage$delegate;
        return (SlottedItemStorage)lazy.getValue();
    }

    @Override
    public void markDataStorageDirty() {
        this.tileEntity.m_6596_();
    }

    @Override
    public <T> T withPlayer(@NotNull Function1<? super FakePlayerProxy, ? extends T> function, @Nullable Direction overwrittenDirection, boolean skipInventory) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        if (!(this.tileEntity instanceof IOwnedBlockEntity)) {
            throw new IllegalArgumentException("Cannot perform player logic without owned block entity");
        }
        return (T)FakePlayerProviderBlockEntity.INSTANCE.withPlayer((BlockEntity)this.tileEntity, arg_0 -> BlockEntityPeripheralOwner.withPlayer$lambda$0(function, arg_0), overwrittenDirection, skipInventory);
    }

    @Override
    @NotNull
    public ItemStack getToolInMainHand() {
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        return itemStack;
    }

    @Override
    @NotNull
    public ItemStack storeItem(@NotNull ItemStack stored) {
        Intrinsics.checkNotNullParameter((Object)stored, (String)"stored");
        if (this.getStorage() == null) {
            return stored;
        }
        SlottedItemStorage slottedItemStorage = this.getStorage();
        Intrinsics.checkNotNull((Object)slottedItemStorage);
        return slottedItemStorage.storeItem(stored);
    }

    @Override
    public void destroyUpgrade() {
        Level level = this.getLevel();
        Intrinsics.checkNotNull((Object)level);
        level.m_7471_(this.tileEntity.m_58899_(), false);
    }

    @Override
    public boolean isMovementPossible(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return false;
    }

    @Override
    public boolean move(@NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return false;
    }

    private static final Object withPlayer$lambda$0(Function1 $tmp0, FakePlayerProxy p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return $tmp0.invoke((Object)p0);
    }

    public static final /* synthetic */ BlockEntity access$getTileEntity$p(BlockEntityPeripheralOwner $this) {
        return $this.tileEntity;
    }
}

