/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.computercraft.peripheral.ability;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IOwnerAbility;
import site.siredvin.peripheralium.api.peripheral.IPeripheralFunction;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.computercraft.peripheral.ability.AbilityToolkit;
import site.siredvin.peripheralium.computercraft.peripheral.ability.FuelAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.OperationAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.PeripheralOwnerAbility;
import site.siredvin.peripheralium.util.Pair;
import site.siredvin.peripheralium.util.ValidationHelpersKt;
import site.siredvin.peripheralium.util.representation.LuaInterpretation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0007J\u001c\u0010\u0018\u001a\u00020\u00132\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\n0\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\b\u0010\u001e\u001a\u00020\u001dH\u0007J\u0006\u0010\u001f\u001a\u00020\u0015J\b\u0010 \u001a\u00020\u0015H\u0007J \u0010!\u001a\u00020\u001d2\u000e\u0010\"\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030#2\u0006\u0010\u0017\u001a\u00020\u0015H\u0007J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0006H\u0007J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0006H\u0007J\u001e\u0010&\u001a\u00020\u001d2\u0014\u0010'\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u001d0(H\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/ExperienceAbility;", "Lsite/siredvin/peripheralium/api/peripheral/IOwnerAbility;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "owner", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "interactionRadius", "", "xpToFuelRate", "xpTransferOperation", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;", "", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;IILsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;)V", "operations", "", "getOperations", "()Ljava/util/List;", "getOwner", "()Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "adjustStoredXP", "", "amount", "", "burnXP", "limit", "collectConfiguration", "data", "", "", "collectXP", "Ldan200/computercraft/api/lua/MethodResult;", "getOwnerXP", "getStoredXP", "getStoredXPLua", "sendXP", "rawBlockPos", "", "sendXPToOwner", "suckOwnerXP", "withXPTransfer", "function", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralFunction;", "Companion", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nExperienceAbility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExperienceAbility.kt\nsite/siredvin/peripheralium/computercraft/peripheral/ability/ExperienceAbility\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1855#2,2:136\n*S KotlinDebug\n*F\n+ 1 ExperienceAbility.kt\nsite/siredvin/peripheralium/computercraft/peripheral/ability/ExperienceAbility\n*L\n56#1:136,2\n*E\n"})
public final class ExperienceAbility
implements IOwnerAbility,
IPeripheralPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IPeripheralOwner owner;
    private final int interactionRadius;
    private final int xpToFuelRate;
    @NotNull
    private final IPeripheralOperation<Object> xpTransferOperation;
    @NotNull
    private static final String COLLECTED_XP_AMOUNT = "CollectedXPAmount";

    public ExperienceAbility(@NotNull IPeripheralOwner owner, int interactionRadius, int xpToFuelRate, @NotNull IPeripheralOperation<Object> xpTransferOperation) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(xpTransferOperation, (String)"xpTransferOperation");
        this.owner = owner;
        this.interactionRadius = interactionRadius;
        this.xpToFuelRate = xpToFuelRate;
        this.xpTransferOperation = xpTransferOperation;
    }

    @NotNull
    public final IPeripheralOwner getOwner() {
        return this.owner;
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return CollectionsKt.listOf(this.xpTransferOperation);
    }

    @Override
    public void collectConfiguration(@NotNull Map<String, Object> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        data.put("xpToFuelRate", this.xpToFuelRate);
    }

    public final double getStoredXP() {
        return this.owner.getDataStorage().m_128459_(COLLECTED_XP_AMOUNT);
    }

    public final void adjustStoredXP(double amount) {
        this.owner.getDataStorage().m_128347_(COLLECTED_XP_AMOUNT, this.owner.getDataStorage().m_128459_(COLLECTED_XP_AMOUNT) + amount);
        this.owner.markDataStorageDirty();
    }

    @NotNull
    protected final MethodResult withXPTransfer(@NotNull IPeripheralFunction<Object, MethodResult> function) throws LuaException {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Object t = this.owner.getAbility(PeripheralOwnerAbility.Companion.getOPERATION());
        Intrinsics.checkNotNull(t);
        OperationAbility ability = (OperationAbility)t;
        return ability.performOperation(this.xpTransferOperation, null, null, function, null, null);
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult collectXP() throws LuaException {
        return this.withXPTransfer(arg_0 -> ExperienceAbility.collectXP$lambda$1(this, arg_0));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult suckOwnerXP(int limit) throws LuaException {
        return this.withXPTransfer(arg_0 -> ExperienceAbility.suckOwnerXP$lambda$2(this, limit, arg_0));
    }

    @LuaFunction(mainThread=true)
    public final double burnXP(double limit) throws LuaException {
        if (limit <= 0.0) {
            throw new LuaException("Incorrect limit");
        }
        FuelAbility fuelAbility = (FuelAbility)this.owner.getAbility(PeripheralOwnerAbility.Companion.getFUEL());
        if (fuelAbility == null) {
            throw new LuaException("Unsupported operation");
        }
        FuelAbility fuelAbility2 = fuelAbility;
        double burnAmount = Math.min(limit, this.getStoredXP());
        this.adjustStoredXP(-burnAmount);
        fuelAbility2.addFuel((int)(burnAmount / (double)this.xpToFuelRate));
        return burnAmount;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult sendXPToOwner(int limit) throws LuaException {
        return this.withXPTransfer(arg_0 -> ExperienceAbility.sendXPToOwner$lambda$3(limit, this, arg_0));
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult sendXP(@NotNull Map<?, ?> rawBlockPos, double limit) throws LuaException {
        Intrinsics.checkNotNullParameter(rawBlockPos, (String)"rawBlockPos");
        BlockPos pos = this.owner.getPos();
        BlockPos targetPos = LuaInterpretation.INSTANCE.asBlockPos(pos, rawBlockPos);
        return this.withXPTransfer(arg_0 -> ExperienceAbility.sendXP$lambda$4(pos, targetPos, this, limit, arg_0));
    }

    @LuaFunction(value={"getStoredXP"}, mainThread=true)
    public final double getStoredXPLua() {
        return this.getStoredXP();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult getOwnerXP() {
        Player player = this.owner.getOwner();
        if (player == null) {
            Object[] objectArray = new Object[]{null, "Cannot find owning player"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find owning player\")");
            return methodResult;
        }
        Player player2 = player;
        MethodResult methodResult = MethodResult.of((Object)player2.f_36079_);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(player.totalExperience)");
        return methodResult;
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods(this, server);
    }

    @Override
    @Nullable
    public String getAdditionalType() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalType(this);
    }

    private static final MethodResult collectXP$lambda$1(ExperienceAbility this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Level level = this$0.owner.getLevel();
        Intrinsics.checkNotNull((Object)level);
        Level level2 = level;
        BlockPos pos = this$0.owner.getPos();
        AABB searchBox = new AABB(pos).m_82400_((double)this$0.interactionRadius);
        double oldCount = this$0.getStoredXP();
        List list = level2.m_45976_(ExperienceOrb.class, searchBox);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"level.getEntitiesOfClass\u2026b::class.java, searchBox)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExperienceOrb entity = (ExperienceOrb)element$iv;
            boolean bl = false;
            this$0.adjustStoredXP(entity.f_20770_);
            entity.m_142687_(Entity.RemovalReason.KILLED);
        }
        MethodResult methodResult = MethodResult.of((Object)(this$0.getStoredXP() - oldCount));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(getStoredXP() - oldCount)");
        return methodResult;
    }

    private static final MethodResult suckOwnerXP$lambda$2(ExperienceAbility this$0, int $limit, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Player player = this$0.owner.getOwner();
        if (player == null) {
            Object[] objectArray = new Object[]{null, "Cannot find owning player"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find owning player\")");
            return methodResult;
        }
        Player player2 = player;
        int suckedCount = Math.min(player2.f_36079_, $limit);
        player2.m_6756_(-suckedCount);
        this$0.adjustStoredXP(suckedCount);
        MethodResult methodResult = MethodResult.of((Object)suckedCount);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(suckedCount)");
        return methodResult;
    }

    private static final MethodResult sendXPToOwner$lambda$3(int $limit, ExperienceAbility this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        double count = Math.min((double)$limit, this$0.getStoredXP());
        Player player = this$0.owner.getOwner();
        if (player == null) {
            Object[] objectArray = new Object[]{null, "Cannot find owning player"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find owning player\")");
            return methodResult;
        }
        Player player2 = player;
        player2.m_6756_((int)count);
        this$0.adjustStoredXP(-count);
        MethodResult methodResult = MethodResult.of((Object)count);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(count)");
        return methodResult;
    }

    private static final MethodResult sendXP$lambda$4(BlockPos $pos, BlockPos $targetPos, ExperienceAbility this$0, double $limit, Object it) {
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)$targetPos, (String)"$targetPos");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!ValidationHelpersKt.radiusCorrect($pos, $targetPos, this$0.interactionRadius)) {
            Object[] objectArray = new Object[]{null, "Turtle are too far away"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Turtle are too far away\")");
            return methodResult;
        }
        PeripheralOwnerAbility<ExperienceAbility> peripheralOwnerAbility = PeripheralOwnerAbility.Companion.getEXPERIENCE();
        Level level = this$0.owner.getLevel();
        Intrinsics.checkNotNull((Object)level);
        Pair<ExperienceAbility, String> abilityExtractResult = AbilityToolkit.INSTANCE.extractAbility(peripheralOwnerAbility, level, $targetPos);
        if (abilityExtractResult.rightPresent()) {
            Object[] objectArray = new Object[]{null, abilityExtractResult.getRight()};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, abilityExtractResult.right)");
            return methodResult;
        }
        double transferAmount = Math.min(this$0.getStoredXP(), $limit);
        this$0.adjustStoredXP(-transferAmount);
        ExperienceAbility experienceAbility = abilityExtractResult.getLeft();
        Intrinsics.checkNotNull((Object)experienceAbility);
        experienceAbility.adjustStoredXP(transferAmount);
        MethodResult methodResult = MethodResult.of((Object)transferAmount);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(transferAmount)");
        return methodResult;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/ExperienceAbility$Companion;", "", "()V", "COLLECTED_XP_AMOUNT", "", "peripheralium-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

