/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.computercraft.peripheral.ability;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.api.peripheral.IOwnedPeripheral;
import site.siredvin.peripheralium.api.peripheral.IOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.PeripheralOwnerAbility;
import site.siredvin.peripheralium.util.Pair;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u0001H\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ7\u0010\u000e\u001a\u0004\u0018\u0001H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0002\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/AbilityToolkit;", "", "()V", "extractAbility", "Lsite/siredvin/peripheralium/util/Pair;", "T", "", "Lsite/siredvin/peripheralium/api/peripheral/IOwnerAbility;", "ability", "Lsite/siredvin/peripheralium/computercraft/peripheral/ability/PeripheralOwnerAbility;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "extractAbilityFromTurtle", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "side", "Ldan200/computercraft/api/turtle/TurtleSide;", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ldan200/computercraft/api/turtle/TurtleSide;Lsite/siredvin/peripheralium/computercraft/peripheral/ability/PeripheralOwnerAbility;)Lsite/siredvin/peripheralium/api/peripheral/IOwnerAbility;", "peripheralium-forge-1.20.1"})
public final class AbilityToolkit {
    @NotNull
    public static final AbilityToolkit INSTANCE = new AbilityToolkit();

    private AbilityToolkit() {
    }

    private final <T extends IOwnerAbility> T extractAbilityFromTurtle(ITurtleAccess turtle, TurtleSide side, PeripheralOwnerAbility<T> ability) {
        IPeripheral targetPeripheral = turtle.getPeripheral(side);
        if (!(targetPeripheral instanceof IOwnedPeripheral)) {
            return null;
        }
        Object t = ((IOwnedPeripheral)targetPeripheral).getPeripheralOwner();
        Intrinsics.checkNotNull(t);
        return t.getAbility(ability);
    }

    @NotNull
    public final <T extends IOwnerAbility> Pair<T, String> extractAbility(@NotNull PeripheralOwnerAbility<T> ability, @NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter(ability, (String)"ability");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return Pair.Companion.onlyRight("Target block doesn't posses required ability");
        }
        BlockEntity entity = blockEntity;
        ITurtleAccess turtle = PeripheraliumPlatform.Companion.getTurtleAccess(entity);
        if (turtle != null) {
            T t = this.extractAbilityFromTurtle(turtle, TurtleSide.LEFT, ability);
            if (t == null && (t = this.extractAbilityFromTurtle(turtle, TurtleSide.RIGHT, ability)) == null) {
                return Pair.Companion.onlyRight("Turtle doesn't posses required ability");
            }
            T targetAbility = t;
            return Pair.Companion.onlyLeft(targetAbility);
        }
        return Pair.Companion.onlyRight("Target block doesn't posses required ability");
    }
}

