/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.common.blocks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.blockentities.IObservingBlockEntity;
import site.siredvin.peripheralium.api.blockentities.IOwnedBlockEntity;
import site.siredvin.peripheralium.api.peripheral.IPeripheralTileEntity;
import site.siredvin.peripheralium.util.BlockUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J8\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u000e\"\b\b\u0001\u0010\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0013H\u0016J8\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J0\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J0\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J2\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\f2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J(\u0010(\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lsite/siredvin/peripheralium/common/blocks/BaseTileEntityBlock;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "belongToTickingEntity", "", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "(ZLnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "tickerLevel", "Lnet/minecraft/world/level/Level;", "tickerState", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "neighborChanged", "", "level", "blockPos", "Lnet/minecraft/core/BlockPos;", "neighbourBlock", "Lnet/minecraft/world/level/block/Block;", "neighbourPos", "bl", "onPlace", "newState", "onRemove", "replace", "setPlacedBy", "pos", "state", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "stack", "Lnet/minecraft/world/item/ItemStack;", "tick", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "peripheralium-forge-1.20.1"})
public abstract class BaseTileEntityBlock<T extends BlockEntity>
extends BaseEntityBlock {
    private final boolean belongToTickingEntity;

    public BaseTileEntityBlock(boolean belongToTickingEntity, @NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.belongToTickingEntity = belongToTickingEntity;
    }

    public /* synthetic */ BaseTileEntityBlock(boolean bl, BlockBehaviour.Properties properties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            properties = BlockUtil.defaultProperties$default(BlockUtil.INSTANCE, 0.0f, 0.0f, 3, null);
        }
        this(bl, properties);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level tickerLevel, @NotNull BlockState tickerState, @NotNull BlockEntityType<T> type) {
        Intrinsics.checkNotNullParameter((Object)tickerLevel, (String)"tickerLevel");
        Intrinsics.checkNotNullParameter((Object)tickerState, (String)"tickerState");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (tickerLevel.f_46443_ || !this.belongToTickingEntity) {
            return null;
        }
        return BaseTileEntityBlock::getTicker$lambda$0;
    }

    public void m_6861_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Block neighbourBlock, @NotNull BlockPos neighbourPos, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)neighbourBlock, (String)"neighbourBlock");
        Intrinsics.checkNotNullParameter((Object)neighbourPos, (String)"neighbourPos");
        super.m_6861_(blockState, level, blockPos, neighbourBlock, neighbourPos, bl);
        BlockEntity tile = level.m_7702_(blockPos);
        if (tile instanceof IObservingBlockEntity) {
            ((IObservingBlockEntity)tile).onNeighbourChange(neighbourPos);
        }
    }

    public void m_213897_(@NotNull BlockState blockState, @NotNull ServerLevel serverLevel, @NotNull BlockPos blockPos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        super.m_213897_(blockState, serverLevel, blockPos, random);
        BlockEntity tile = serverLevel.m_7702_(blockPos);
        if (tile instanceof IObservingBlockEntity) {
            ((IObservingBlockEntity)tile).blockTick();
        }
    }

    public void m_6807_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState newState, boolean bl) {
        BlockEntity tile;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        super.m_6807_(blockState, level, blockPos, newState, bl);
        if (newState.m_60734_() == this && (tile = level.m_7702_(blockPos)) instanceof IObservingBlockEntity) {
            ((IObservingBlockEntity)tile).placed();
        }
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        super.m_6402_(level, pos, state, entity, stack);
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof IOwnedBlockEntity && !level.f_46443_ && entity instanceof Player) {
            ((IOwnedBlockEntity)tile).setPlayer((Player)entity);
        }
        if (tile instanceof IObservingBlockEntity) {
            ((IObservingBlockEntity)tile).setPlacedBy(entity, stack);
        }
    }

    public void m_6810_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState replace, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)replace, (String)"replace");
        if (blockState.m_60734_() == replace.m_60734_()) {
            return;
        }
        BlockEntity tile = level.m_7702_(blockPos);
        super.m_6810_(blockState, level, blockPos, replace, bl);
        if (tile instanceof IObservingBlockEntity) {
            ((IObservingBlockEntity)tile).destroy();
        }
    }

    private static final void getTicker$lambda$0(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        if (entity instanceof IPeripheralTileEntity) {
            IPeripheralTileEntity iPeripheralTileEntity = (IPeripheralTileEntity)entity;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level");
            Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
            Intrinsics.checkNotNullExpressionValue((Object)state, (String)"state");
            iPeripheralTileEntity.handleTick(level, pos, state);
        }
    }
}

