/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.common.blocks;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.blockentities.ISyncingBlockEntity;
import site.siredvin.peripheralium.common.blocks.BaseTileEntityBlock;
import site.siredvin.peripheralium.util.BlockUtil;
import site.siredvin.peripheralium.xplat.XplatRegistries;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \"*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001\"B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H&J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J2\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0010H\u0016R\u001e\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lsite/siredvin/peripheralium/common/blocks/BaseNBTBlock;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lsite/siredvin/peripheralium/api/blockentities/ISyncingBlockEntity;", "Lsite/siredvin/peripheralium/common/blocks/BaseTileEntityBlock;", "belongToTickingEntity", "", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "(ZLnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "savableProperties", "", "Lnet/minecraft/world/level/block/state/properties/Property;", "getSavableProperties", "()Ljava/util/List;", "createItemStack", "Lnet/minecraft/world/item/ItemStack;", "playerWillDestroy", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "player", "Lnet/minecraft/world/entity/player/Player;", "prepareItemStack", "blockEntity", "setPlacedBy", "initialState", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "stack", "Companion", "peripheralium-forge-1.20.1"})
public abstract class BaseNBTBlock<T extends BlockEntity>
extends BaseTileEntityBlock<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String INTERNAL_DATA_TAG = "internalData";
    @NotNull
    public static final String BLOCK_STATE_TAG = "blockState";

    public BaseNBTBlock(boolean belongToTickingEntity, @NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(belongToTickingEntity, properties);
    }

    public /* synthetic */ BaseNBTBlock(boolean bl, BlockBehaviour.Properties properties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            properties = BlockUtil.defaultProperties$default(BlockUtil.INSTANCE, 0.0f, 0.0f, 3, null);
        }
        this(bl, properties);
    }

    @NotNull
    public abstract ItemStack createItemStack();

    @NotNull
    public ItemStack prepareItemStack(@NotNull ISyncingBlockEntity blockEntity, @NotNull BlockState state) {
        List<Property<?>> savableProperties;
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ItemStack stack = this.createItemStack();
        CompoundTag internalData = blockEntity.saveInternalData(new CompoundTag());
        if (!internalData.m_128456_()) {
            stack.m_41700_(INTERNAL_DATA_TAG, (Tag)internalData);
        }
        if (!((Collection)(savableProperties = this.getSavableProperties())).isEmpty() && !this.m_49966_().equals((Object)state)) {
            stack.m_41700_(BLOCK_STATE_TAG, (Tag)NbtUtils.m_129202_((BlockState)state));
        }
        return stack;
    }

    @NotNull
    public List<Property<?>> getSavableProperties() {
        return CollectionsKt.emptyList();
    }

    public void m_5707_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ISyncingBlockEntity && !level.f_46443_ && !player.m_7500_()) {
            ItemStack stack = this.prepareItemStack((ISyncingBlockEntity)blockEntity, state);
            ItemEntity itemDrop = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            itemDrop.m_32060_();
            level.m_7967_((Entity)itemDrop);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState initialState, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        CompoundTag data;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)initialState, (String)"initialState");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        BlockState state = initialState;
        super.m_6402_(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ISyncingBlockEntity && !level.f_46443_ && (data = stack.m_41783_()) != null) {
            if (data.m_128441_(BLOCK_STATE_TAG)) {
                BlockState blockState = NbtUtils.m_247651_((HolderGetter)XplatRegistries.INSTANCE.getBLOCKS(), (CompoundTag)data.m_128469_(BLOCK_STATE_TAG));
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"readBlockState(XplatRegi\u2026ompound(BLOCK_STATE_TAG))");
                BlockState savedState = blockState;
                for (Property<?> property : this.getSavableProperties()) {
                    Intrinsics.checkNotNull(property, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.properties.Property<kotlin.Comparable<kotlin.Any>>");
                    Comparable comparable = savedState.m_61143_(property);
                    Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
                    Object object = state.m_61124_(property, comparable);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"state.setValue(property,\u2026erty) as Comparable<Any>)");
                    state = (BlockState)object;
                }
            }
            if (data.m_128441_(INTERNAL_DATA_TAG)) {
                ISyncingBlockEntity iSyncingBlockEntity = (ISyncingBlockEntity)blockEntity;
                CompoundTag compoundTag = data.m_128469_(INTERNAL_DATA_TAG);
                Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"data.getCompound(INTERNAL_DATA_TAG)");
                state = iSyncingBlockEntity.loadInternalData(compoundTag, state);
                ((ISyncingBlockEntity)blockEntity).pushInternalDataChangeToClient(state);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralium/common/blocks/BaseNBTBlock$Companion;", "", "()V", "BLOCK_STATE_TAG", "", "INTERNAL_DATA_TAG", "peripheralium-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

