/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.common.blockentities;

import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.blockentities.IOwnedBlockEntity;
import site.siredvin.peripheralium.api.peripheral.IOwnedPeripheral;
import site.siredvin.peripheralium.api.peripheral.IPeripheralProvider;
import site.siredvin.peripheralium.api.peripheral.IPeripheralTileEntity;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 4*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u00032\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u00052\u00020\u0006:\u00014B!\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020,H$\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020,J\u0017\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010+\u001a\u00020,H\u0016\u00a2\u0006\u0002\u0010-J\u0010\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020 H\u0016J\b\u00102\u001a\u00020/H\u0016J\u0010\u00103\u001a\u00020/2\u0006\u00101\u001a\u00020 H\u0014R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u0004\u0018\u00018\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001e\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 @DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R(\u0010'\u001a\u0004\u0018\u00010\u00142\b\u0010&\u001a\u0004\u0018\u00010\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010\u0016\"\u0004\b)\u0010\u0018\u00a8\u00065"}, d2={"Lsite/siredvin/peripheralium/common/blockentities/PeripheralBlockEntity;", "T", "Lsite/siredvin/peripheralium/api/peripheral/IOwnedPeripheral;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralTileEntity;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralProvider;", "Lsite/siredvin/peripheralium/api/blockentities/IOwnedBlockEntity;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "connectedComputers", "", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "getConnectedComputers", "()Ljava/util/List;", "owningPlayer", "Lnet/minecraft/world/entity/player/Player;", "getOwningPlayer", "()Lnet/minecraft/world/entity/player/Player;", "setOwningPlayer", "(Lnet/minecraft/world/entity/player/Player;)V", "peripheral", "getPeripheral", "()Lsite/siredvin/peripheralium/api/peripheral/IOwnedPeripheral;", "setPeripheral", "(Lsite/siredvin/peripheralium/api/peripheral/IOwnedPeripheral;)V", "Lsite/siredvin/peripheralium/api/peripheral/IOwnedPeripheral;", "<set-?>", "Lnet/minecraft/nbt/CompoundTag;", "peripheralSettings", "getPeripheralSettings", "()Lnet/minecraft/nbt/CompoundTag;", "setPeripheralSettings", "(Lnet/minecraft/nbt/CompoundTag;)V", "value", "player", "getPlayer", "setPlayer", "createPeripheral", "side", "Lnet/minecraft/core/Direction;", "(Lnet/minecraft/core/Direction;)Lsite/siredvin/peripheralium/api/peripheral/IOwnedPeripheral;", "ensurePeripheralCreated", "", "load", "compound", "markSettingsChanged", "saveAdditional", "Companion", "peripheralium-forge-1.20.1"})
public abstract class PeripheralBlockEntity<T extends IOwnedPeripheral<?>>
extends BlockEntity
implements IPeripheralTileEntity,
IPeripheralProvider<T>,
IOwnedBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CompoundTag peripheralSettings;
    @Nullable
    private T peripheral;
    @Nullable
    private Player owningPlayer;
    @NotNull
    private static final String PERIPHERAL_DATA_TAG = "peripheralData";
    @NotNull
    private static final String OWNER_PROFILE_TAG = "ownerProfile";

    public PeripheralBlockEntity(@NotNull BlockEntityType<?> blockEntityType, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockEntityType, blockPos, blockState);
        this.peripheralSettings = new CompoundTag();
    }

    @Override
    @NotNull
    public final CompoundTag getPeripheralSettings() {
        return this.peripheralSettings;
    }

    protected final void setPeripheralSettings(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"<set-?>");
        this.peripheralSettings = compoundTag;
    }

    @Nullable
    protected final T getPeripheral() {
        return this.peripheral;
    }

    protected final void setPeripheral(@Nullable T t) {
        this.peripheral = t;
    }

    @Nullable
    protected final Player getOwningPlayer() {
        return this.owningPlayer;
    }

    protected final void setOwningPlayer(@Nullable Player player) {
        this.owningPlayer = player;
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.owningPlayer;
    }

    @Override
    public void setPlayer(@Nullable Player value) {
        this.owningPlayer = value;
    }

    @NotNull
    public final List<IComputerAccess> getConnectedComputers() {
        List<IComputerAccess> list;
        if (this.peripheral == null) {
            list = CollectionsKt.emptyList();
        } else {
            T t = this.peripheral;
            Intrinsics.checkNotNull(t);
            list = t.getConnectedComputers();
        }
        return list;
    }

    @Override
    @Nullable
    public T getPeripheral(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        this.ensurePeripheralCreated(side);
        T t = this.peripheral;
        Intrinsics.checkNotNull(t);
        return t;
    }

    public final void ensurePeripheralCreated(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (this.peripheral == null) {
            this.peripheral = this.createPeripheral(side);
        }
    }

    @NotNull
    protected abstract T createPeripheral(@NotNull Direction var1);

    protected void m_183515_(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.m_183515_(compound);
        if (!this.peripheralSettings.m_128456_()) {
            compound.m_128365_(PERIPHERAL_DATA_TAG, (Tag)this.peripheralSettings);
        }
        if (this.owningPlayer != null) {
            Player player = this.owningPlayer;
            Intrinsics.checkNotNull((Object)player);
            if (player.m_36316_().getId() != null) {
                Player player2 = this.owningPlayer;
                Intrinsics.checkNotNull((Object)player2);
                compound.m_128362_(OWNER_PROFILE_TAG, player2.m_36316_().getId());
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        if (compound.m_128441_(PERIPHERAL_DATA_TAG)) {
            CompoundTag compoundTag = compound.m_128469_(PERIPHERAL_DATA_TAG);
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"compound.getCompound(PERIPHERAL_DATA_TAG)");
            this.peripheralSettings = compoundTag;
        }
        if (compound.m_128441_(OWNER_PROFILE_TAG) && this.f_58857_ != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (!level.f_46443_) {
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                this.owningPlayer = ((ServerLevel)level2).m_46003_(compound.m_128342_(OWNER_PROFILE_TAG));
            }
        }
        super.m_142466_(compound);
    }

    @Override
    public void markSettingsChanged() {
        this.m_6596_();
    }

    @Override
    public void handleTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        IPeripheralTileEntity.DefaultImpls.handleTick(this, level, pos, state);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lsite/siredvin/peripheralium/common/blockentities/PeripheralBlockEntity$Companion;", "", "()V", "OWNER_PROFILE_TAG", "", "PERIPHERAL_DATA_TAG", "peripheralium-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

