/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.panoramica;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import de.keksuccino.panoramica.DummyScreen;
import de.keksuccino.panoramica.Keybinds;
import de.keksuccino.panoramica.Panoramica;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.glfw.GLFW;

public class LegacyPanoramicaHandler {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    public static boolean panoramicMode = false;
    private List<NativeImage> screenshots = new ArrayList<NativeImage>();
    private int tick = 1;
    private int prevTick = 1;
    private boolean active = false;
    private int shotsTaken = 0;
    private boolean prepareScreenshot = false;
    private int delay = 10;
    private int width = 0;
    private int height = 0;
    private boolean cachedGuiVisibility;
    private File saveDirectory;
    private Minecraft mc = Minecraft.m_91087_();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new LegacyPanoramicaHandler());
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            block17: {
                try {
                    if (Keybinds.keybindCreatePano.m_90857_()) {
                        if (!this.mc.m_91268_().m_85440_()) {
                            if (!this.active) {
                                this.active = true;
                                this.tick = 0;
                                this.prevTick = 0;
                                this.prepareScreenshot = false;
                                this.shotsTaken = 0;
                                panoramicMode = true;
                                this.delay = (Integer)Panoramica.config.getOrDefault("screenshotdelay", (Object)10);
                                this.width = 0;
                                this.height = 0;
                                this.screenshots.clear();
                                this.saveDirectory = LegacyPanoramicaHandler.getUnusedPanoramaFolderName();
                                if (!this.saveDirectory.exists()) {
                                    this.saveDirectory.mkdirs();
                                }
                                this.cachedGuiVisibility = this.mc.f_91066_.f_92062_;
                                this.mc.f_91066_.f_92062_ = true;
                                this.mc.m_91152_((Screen)new DummyScreen());
                            }
                        } else {
                            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cPlease disable fullscreen mode before creating a panorama!"));
                        }
                    }
                    if (this.active) {
                        this.mc.f_91067_.m_91602_();
                        if (this.tick == 0) {
                            ++this.tick;
                            this.width = this.mc.m_91268_().m_85441_();
                            this.height = this.mc.m_91268_().m_85442_();
                            int res = (Integer)Panoramica.config.getOrDefault("panoramaresolution", (Object)512);
                            GLFW.glfwSetWindowSizeLimits((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)100, (int)100, (int)20000, (int)20000);
                            GLFW.glfwSetWindowSize((long)this.mc.m_91268_().m_85439_(), (int)res, (int)res);
                            Minecraft.m_91087_().m_5741_();
                        } else {
                            if (this.tick >= this.prevTick + this.delay) {
                                if (!this.prepareScreenshot) {
                                    this.setCameraRotation();
                                    this.prevTick = this.tick;
                                    this.prepareScreenshot = true;
                                } else {
                                    this.takeScreenshot();
                                    ++this.shotsTaken;
                                    this.prevTick = this.tick;
                                    this.prepareScreenshot = false;
                                }
                            }
                            ++this.tick;
                        }
                        if (this.shotsTaken >= 6) {
                            this.tick = 0;
                            this.active = false;
                            if (this.mc.f_91080_ instanceof DummyScreen) {
                                this.mc.m_91152_(null);
                            }
                            this.finishPanorama();
                            GLFW.glfwSetWindowSize((long)this.mc.m_91268_().m_85439_(), (int)this.width, (int)this.height);
                            Minecraft.m_91087_().m_5741_();
                            this.mc.f_91066_.f_92062_ = this.cachedGuiVisibility;
                            this.mc.f_91067_.m_91601_();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.active = false;
                    if (!(this.mc.f_91080_ instanceof DummyScreen)) break block17;
                    this.mc.m_91152_(null);
                }
            }
            if (!this.active) {
                panoramicMode = false;
            }
        }
    }

    private void setCameraRotation() {
        if (this.shotsTaken == 0) {
            this.mc.f_91074_.m_7678_(this.mc.f_91074_.m_20185_(), this.mc.f_91074_.m_20186_(), this.mc.f_91074_.m_20189_(), -180.0f, 0.0f);
        }
        if (this.shotsTaken == 1) {
            this.mc.f_91074_.m_7678_(this.mc.f_91074_.m_20185_(), this.mc.f_91074_.m_20186_(), this.mc.f_91074_.m_20189_(), -90.0f, 0.0f);
        }
        if (this.shotsTaken == 2) {
            this.mc.f_91074_.m_7678_(this.mc.f_91074_.m_20185_(), this.mc.f_91074_.m_20186_(), this.mc.f_91074_.m_20189_(), 0.0f, 0.0f);
        }
        if (this.shotsTaken == 3) {
            this.mc.f_91074_.m_7678_(this.mc.f_91074_.m_20185_(), this.mc.f_91074_.m_20186_(), this.mc.f_91074_.m_20189_(), 90.0f, 0.0f);
        }
        if (this.shotsTaken == 4) {
            this.mc.f_91074_.m_7678_(this.mc.f_91074_.m_20185_(), this.mc.f_91074_.m_20186_(), this.mc.f_91074_.m_20189_(), -180.0f, -90.0f);
        }
        if (this.shotsTaken == 5) {
            this.mc.f_91074_.m_7678_(this.mc.f_91074_.m_20185_(), this.mc.f_91074_.m_20186_(), this.mc.f_91074_.m_20189_(), -180.0f, 90.0f);
        }
    }

    private void takeScreenshot() {
        this.screenshots.add(Screenshot.m_92279_((RenderTarget)this.mc.m_91385_()));
    }

    private boolean finishPanorama() {
        try {
            if (this.screenshots.size() == 6) {
                int i = 0;
                for (NativeImage ni : this.screenshots) {
                    try {
                        ni.m_85056_(new File(this.saveDirectory.getPath() + "/panorama_" + i + ".png"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                MutableComponent compSaveDir = Component.m_237113_((String)this.saveDirectory.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.saveDirectory.getAbsolutePath())));
                MutableComponent compSuccessMsg = Component.m_237110_((String)"screenshot.success", (Object[])new Object[]{compSaveDir});
                Minecraft.m_91087_().f_91074_.m_213846_((Component)compSuccessMsg);
                return true;
            }
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cError! Unable to save panorama!"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static File getUnusedPanoramaFolderName() {
        File saveTo = new File(Minecraft.m_91087_().f_91069_.getPath() + "/screenshots");
        try {
            return LegacyPanoramicaHandler.getFolder(saveTo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new File(saveTo.getPath() + "/panorama_" + System.currentTimeMillis());
        }
    }

    private static File getFolder(File file) {
        File file2;
        String string = DATE_FORMAT.format(new Date());
        int i = 1;
        while ((file2 = new File(file, "panorama_" + string + (String)(i == 1 ? "" : "_" + i))).exists()) {
            ++i;
        }
        return file2;
    }
}

