/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsbp.datagen;

import com.google.common.collect.ImmutableMap;
import com.nyfaria.nyfsbp.init.BannerPatternInit;
import com.nyfaria.nyfsbp.init.ItemInit;
import com.nyfaria.nyfsbp.registration.RegistryObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.common.data.LanguageProvider;
import org.apache.commons.lang3.StringUtils;

public class ModLangProvider
extends LanguageProvider {
    protected static final Map<String, String> REPLACE_LIST = ImmutableMap.of((Object)"tnt", (Object)"TNT", (Object)"sus", (Object)"");

    public ModLangProvider(PackOutput gen) {
        super(gen, "nyfsbp", "en_us");
    }

    protected void addTranslations() {
        ItemInit.ITEMS.getEntries().forEach(this::itemLang);
        BannerPatternInit.BANNER_PATTERNS.getEntries().forEach(this::bannerPatternLang);
    }

    private void bannerPatternLang(RegistryObject<BannerPattern> entry) {
        for (DyeColor color : DyeColor.values()) {
            this.add("block.minecraft.banner." + entry.getId().m_135827_() + "." + entry.getId().m_135815_() + "." + color.m_41065_(), this.checkReplace(color.m_41065_()) + " " + this.checkReplace(entry));
        }
    }

    protected void itemLang(RegistryObject<Item> entry) {
        if (!(entry.get() instanceof BlockItem) || entry.get() instanceof ItemNameBlockItem) {
            this.addItem(entry, this.checkReplaceBannerItem(entry));
            this.add(entry.get().m_5524_() + ".desc", this.checkReplaceBannerItemDesc(entry));
        }
    }

    protected void blockLang(RegistryObject<Block> entry) {
        this.addBlock(entry, this.checkReplace(entry));
    }

    protected void entityLang(RegistryObject<EntityType<?>> entry) {
        this.addEntityType(entry, this.checkReplace(entry));
    }

    protected String checkReplaceBannerItem(RegistryObject<?> registryObject) {
        return Arrays.stream(registryObject.getId().m_135815_().split("_")).filter(s -> !s.isBlank() && List.of("banner", "pattern").contains(s)).map(this::checkReplace).collect(Collectors.joining(" ")).trim();
    }

    protected String checkReplaceBannerItemDesc(RegistryObject<?> registryObject) {
        return Arrays.stream(registryObject.getId().m_135815_().split("_")).filter(s -> !s.isBlank() && !List.of("banner", "pattern").contains(s)).map(this::checkReplace).collect(Collectors.joining(" ")).trim();
    }

    protected String checkReplace(RegistryObject<?> registryObject) {
        return Arrays.stream(registryObject.getId().m_135815_().split("_")).map(this::checkReplace).filter(s -> !s.isBlank()).collect(Collectors.joining(" ")).trim();
    }

    protected String checkReplace(String string) {
        return REPLACE_LIST.containsKey(string) ? REPLACE_LIST.get(string) : StringUtils.capitalize((String)string);
    }
}

