/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsbp.datagen;

import com.nyfaria.nyfsbp.init.ItemInit;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput generator, ExistingFileHelper existingFileHelper) {
        super(generator, "nyfsbp", existingFileHelper);
    }

    protected void registerModels() {
        ItemInit.ITEMS.getEntries().stream().map(Supplier::get).forEach(this::simpleGeneratedModel);
    }

    protected ItemModelBuilder simpleBlockItemModel(Block block) {
        String name = this.getName(block);
        return (ItemModelBuilder)this.withExistingParent(name, this.modLoc("block/" + name));
    }

    protected ItemModelBuilder simpleGeneratedModel(Item item) {
        return this.simpleModel(item, this.mcLoc("item/generated"));
    }

    protected ItemModelBuilder simpleHandHeldModel(Item item) {
        return this.simpleModel(item, this.mcLoc("item/handheld"));
    }

    protected ItemModelBuilder simpleModel(Item item, ResourceLocation parent) {
        String name = this.getName(item);
        return (ItemModelBuilder)this.singleTexture(name, parent, "layer0", this.modLoc("item/" + name));
    }

    protected String getName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    protected String getName(Block item) {
        return ForgeRegistries.BLOCKS.getKey((Object)item).m_135815_();
    }
}

