/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.org.jsoup.nodes;

import java.io.IOException;
import mods.thecomputerizer.shadow.org.jsoup.helper.Validate;
import mods.thecomputerizer.shadow.org.jsoup.internal.StringUtil;
import mods.thecomputerizer.shadow.org.jsoup.nodes.Document;
import mods.thecomputerizer.shadow.org.jsoup.nodes.LeafNode;
import org.jspecify.annotations.Nullable;

public class DocumentType
extends LeafNode {
    public static final String PUBLIC_KEY = "PUBLIC";
    public static final String SYSTEM_KEY = "SYSTEM";
    private static final String NameKey = "name";
    private static final String PubSysKey = "pubSysKey";
    private static final String PublicId = "publicId";
    private static final String SystemId = "systemId";

    public DocumentType(String name, String publicId, String systemId) {
        super(name);
        Validate.notNull(publicId);
        Validate.notNull(systemId);
        this.attributes().add(NameKey, name).add(PublicId, publicId).add(SystemId, systemId);
        this.updatePubSyskey();
    }

    public void setPubSysKey(@Nullable String value) {
        if (value != null) {
            this.attr(PubSysKey, value);
        }
    }

    private void updatePubSyskey() {
        if (this.has(PublicId)) {
            this.attributes().add(PubSysKey, PUBLIC_KEY);
        } else if (this.has(SystemId)) {
            this.attributes().add(PubSysKey, SYSTEM_KEY);
        }
    }

    public String name() {
        return this.attr(NameKey);
    }

    public String publicId() {
        return this.attr(PublicId);
    }

    public String systemId() {
        return this.attr(SystemId);
    }

    @Override
    public String nodeName() {
        return "#doctype";
    }

    @Override
    void outerHtmlHead(Appendable accum, Document.OutputSettings out) throws IOException {
        if (out.syntax() == Document.OutputSettings.Syntax.html && !this.has(PublicId) && !this.has(SystemId)) {
            accum.append("<!doctype");
        } else {
            accum.append("<!DOCTYPE");
        }
        if (this.has(NameKey)) {
            accum.append(" ").append(this.attr(NameKey));
        }
        if (this.has(PubSysKey)) {
            accum.append(" ").append(this.attr(PubSysKey));
        }
        if (this.has(PublicId)) {
            accum.append(" \"").append(this.attr(PublicId)).append('\"');
        }
        if (this.has(SystemId)) {
            accum.append(" \"").append(this.attr(SystemId)).append('\"');
        }
        accum.append('>');
    }

    private boolean has(String attribute) {
        return !StringUtil.isBlank(this.attr(attribute));
    }
}

