/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import mods.thecomputerizer.shadow.org.apache.http.HttpConnection;
import mods.thecomputerizer.shadow.org.apache.http.HttpException;
import mods.thecomputerizer.shadow.org.apache.http.HttpHost;
import mods.thecomputerizer.shadow.org.apache.http.HttpInetConnection;
import mods.thecomputerizer.shadow.org.apache.http.HttpRequest;
import mods.thecomputerizer.shadow.org.apache.http.HttpRequestInterceptor;
import mods.thecomputerizer.shadow.org.apache.http.HttpVersion;
import mods.thecomputerizer.shadow.org.apache.http.ProtocolException;
import mods.thecomputerizer.shadow.org.apache.http.ProtocolVersion;
import mods.thecomputerizer.shadow.org.apache.http.annotation.Contract;
import mods.thecomputerizer.shadow.org.apache.http.annotation.ThreadingBehavior;
import mods.thecomputerizer.shadow.org.apache.http.protocol.HttpContext;
import mods.thecomputerizer.shadow.org.apache.http.protocol.HttpCoreContext;
import mods.thecomputerizer.shadow.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

