/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.org.apache.http.protocol;

import java.io.IOException;
import mods.thecomputerizer.shadow.org.apache.http.HttpEntity;
import mods.thecomputerizer.shadow.org.apache.http.HttpEntityEnclosingRequest;
import mods.thecomputerizer.shadow.org.apache.http.HttpException;
import mods.thecomputerizer.shadow.org.apache.http.HttpRequest;
import mods.thecomputerizer.shadow.org.apache.http.HttpRequestInterceptor;
import mods.thecomputerizer.shadow.org.apache.http.HttpVersion;
import mods.thecomputerizer.shadow.org.apache.http.ProtocolVersion;
import mods.thecomputerizer.shadow.org.apache.http.annotation.Contract;
import mods.thecomputerizer.shadow.org.apache.http.annotation.ThreadingBehavior;
import mods.thecomputerizer.shadow.org.apache.http.protocol.HttpContext;
import mods.thecomputerizer.shadow.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

