/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.me.devoxin.lavadspx;

import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;

public class NormalizationFilter
implements FloatPcmAudioFilter {
    private final FloatPcmAudioFilter downstream;
    private float maxAmplitude;
    private boolean adaptive;
    private float peakAmplitude = 0.0f;

    public NormalizationFilter(FloatPcmAudioFilter downstream, float maxAmplitude) {
        this(downstream, maxAmplitude, true);
    }

    public NormalizationFilter(FloatPcmAudioFilter downstream, float maxAmplitude, boolean adaptive) {
        this.downstream = downstream;
        this.adaptive = adaptive;
        this.setMaxAmplitude(maxAmplitude);
    }

    public void setMaxAmplitude(float maxAmplitude) {
        this.maxAmplitude = Math.max(0.0f, Math.min(1.0f, maxAmplitude));
    }

    public float getMaxAmplitude() {
        return this.maxAmplitude;
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        if (!this.adaptive) {
            this.peakAmplitude = 0.0f;
        }
        for (int channel = 0; channel < input.length; ++channel) {
            for (int i = offset; i < offset + length; ++i) {
                this.peakAmplitude = Math.max(this.peakAmplitude, Math.abs(input[channel][i]));
            }
            if (!(this.peakAmplitude > this.maxAmplitude)) continue;
            int j = offset;
            while (j < offset + length) {
                float[] fArray = input[channel];
                int n = j++;
                fArray[n] = fArray[n] / (this.peakAmplitude / this.maxAmplitude);
            }
        }
        this.downstream.process(input, offset, length);
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
    }

    @Override
    public void flush() {
        this.peakAmplitude = 0.0f;
    }

    @Override
    public void close() {
    }
}

