/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.me.devoxin.lavadspx;

import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.filter.FloatPcmAudioFilter;

public abstract class GenericPassFilter
implements FloatPcmAudioFilter {
    public static final float DEFAULT_BOOST_FACTOR = 1.0f;
    private final FloatPcmAudioFilter downstream;
    protected final int sampleRate;
    private float boostFactor;
    protected final double[] b = new double[3];
    protected final double[] a = new double[3];
    protected final float[][] x1;
    protected final float[][] y1;

    protected GenericPassFilter(FloatPcmAudioFilter downstream, int sampleRate, int channelCount, int cutoffFrequency) {
        this(downstream, sampleRate, channelCount, cutoffFrequency, 1.0f);
    }

    protected GenericPassFilter(FloatPcmAudioFilter downstream, int sampleRate, int channelCount, int cutoffFrequency, float boostFactor) {
        this.downstream = downstream;
        this.sampleRate = sampleRate;
        this.boostFactor = boostFactor;
        this.x1 = new float[channelCount][2];
        this.y1 = new float[channelCount][2];
        this.setCutoffFrequency(cutoffFrequency);
    }

    public abstract void setCutoffFrequency(int var1);

    public void setBoostFactor(float boostFactor) {
        this.boostFactor = boostFactor;
    }

    public float getBoostFactor() {
        return this.boostFactor;
    }

    @Override
    public void process(float[][] input, int offset, int length) throws InterruptedException {
        for (int channel = 0; channel < input.length; ++channel) {
            for (int i = offset; i < offset + length; ++i) {
                float x0 = input[channel][i];
                float y0 = (float)(this.b[0] * (double)x0 + this.b[1] * (double)this.x1[channel][0] + this.b[2] * (double)this.x1[channel][1] - this.a[1] * (double)this.y1[channel][0] - this.a[2] * (double)this.y1[channel][1]);
                this.x1[channel][1] = this.x1[channel][0];
                this.x1[channel][0] = x0;
                this.y1[channel][1] = this.y1[channel][0];
                this.y1[channel][0] = y0;
                input[channel][i] = Math.min(1.0f, Math.max(-1.0f, y0 * this.boostFactor));
            }
        }
        this.downstream.process(input, offset, length);
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
    }

    @Override
    public void flush() {
        int channel;
        for (channel = 0; channel < this.x1.length; ++channel) {
            this.x1[channel][0] = 0.0f;
            this.x1[channel][1] = 0.0f;
        }
        for (channel = 0; channel < this.y1.length; ++channel) {
            this.y1[channel][0] = 0.0f;
            this.y1[channel][1] = 0.0f;
        }
    }

    @Override
    public void close() {
    }
}

