/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.ibxm;

public class Envelope {
    public boolean enabled = false;
    public boolean sustain = false;
    public boolean looped = false;
    public int sustainTick = 0;
    public int loopStartTick = 0;
    public int loopEndTick = 0;
    public int numPoints = 1;
    public int[] pointsTick = new int[1];
    public int[] pointsAmpl = new int[1];

    public int nextTick(int tick, boolean keyOn) {
        if (this.looped && ++tick >= this.loopEndTick) {
            tick = this.loopStartTick;
        }
        if (this.sustain && keyOn && tick >= this.sustainTick) {
            tick = this.sustainTick;
        }
        return tick;
    }

    public int calculateAmpl(int tick) {
        int ampl = this.pointsAmpl[this.numPoints - 1];
        if (tick < this.pointsTick[this.numPoints - 1]) {
            int point = 0;
            for (int idx = 1; idx < this.numPoints; ++idx) {
                if (this.pointsTick[idx] > tick) continue;
                point = idx;
            }
            int dt = this.pointsTick[point + 1] - this.pointsTick[point];
            int da = this.pointsAmpl[point + 1] - this.pointsAmpl[point];
            ampl = this.pointsAmpl[point];
            ampl += (da << 24) / dt * (tick - this.pointsTick[point]) >> 24;
        }
        return ampl;
    }

    public void toStringBuffer(StringBuffer out, String prefix) {
        if (this.sustain) {
            out.append(prefix + "Sustain Tick: " + this.sustainTick + '\n');
        }
        if (this.looped) {
            out.append(prefix + "Loop Start Tick: " + this.loopStartTick + '\n');
            out.append(prefix + "Loop End Tick: " + this.loopEndTick + '\n');
        }
        out.append(prefix + "Points:");
        for (int point = 0; point < this.numPoints; ++point) {
            if (point % 3 == 0) {
                out.append('\n' + prefix + prefix);
            }
            out.append("(" + this.pointsTick[point] + ", " + this.pointsAmpl[point] + "), ");
        }
        out.append('\n');
    }
}

