/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.lava.extensions.youtuberotator;

import java.net.BindException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.http.HttpContextFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.lava.extensions.youtuberotator.planner.AbstractRoutePlanner;
import mods.thecomputerizer.shadow.com.sedmelluq.lava.extensions.youtuberotator.tools.RateLimitException;
import mods.thecomputerizer.shadow.org.apache.http.HttpResponse;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.HttpUriRequest;
import mods.thecomputerizer.shadow.org.apache.http.client.protocol.HttpClientContext;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public class YoutubeIpRotatorFilter
implements HttpContextFilter {
    private static final Logger log = LoggerFactory.getLogger(YoutubeIpRotatorFilter.class);
    private static final String RETRY_COUNT_ATTRIBUTE = "yt-retry-counter";
    private final HttpContextFilter delegate;
    private final boolean isSearch;
    private final AbstractRoutePlanner routePlanner;
    private final int retryLimit;

    public YoutubeIpRotatorFilter(HttpContextFilter delegate, boolean isSearch, AbstractRoutePlanner routePlanner, int retryLimit) {
        this.delegate = delegate;
        this.isSearch = isSearch;
        this.routePlanner = routePlanner;
        this.retryLimit = retryLimit;
    }

    @Override
    public void onContextOpen(HttpClientContext context) {
        if (this.delegate != null) {
            this.delegate.onContextOpen(context);
        }
    }

    @Override
    public void onContextClose(HttpClientContext context) {
        if (this.delegate != null) {
            this.delegate.onContextClose(context);
        }
    }

    @Override
    public void onRequest(HttpClientContext context, HttpUriRequest request, boolean isRepetition) {
        if (isRepetition) {
            this.setRetryCount(context, this.getRetryCount(context) + 1);
        } else {
            this.setRetryCount(context, 0);
        }
        if (this.delegate != null) {
            this.delegate.onRequest(context, request, isRepetition);
        }
    }

    @Override
    public boolean onRequestResponse(HttpClientContext context, HttpUriRequest request, HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (this.isSearch) {
            if (statusCode == 429) {
                if (this.routePlanner.shouldHandleSearchFailure()) {
                    log.warn("YouTube search rate limit reached, marking address as failing and retry");
                    this.routePlanner.markAddressFailing(context);
                }
                return this.limitedRetry(context);
            }
        } else if (this.isRateLimited(response)) {
            log.warn("YouTube rate limit reached, marking address {} as failing and retry", (Object)this.routePlanner.getLastAddress(context));
            this.routePlanner.markAddressFailing(context);
            return this.limitedRetry(context);
        }
        if (this.delegate != null) {
            return this.delegate.onRequestResponse(context, request, response);
        }
        return false;
    }

    private boolean isRateLimited(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode == 429;
    }

    @Override
    public boolean onRequestException(HttpClientContext context, HttpUriRequest request, Throwable error) {
        if (error instanceof BindException) {
            log.warn("Cannot assign requested address {}, marking address as failing and retry!", (Object)this.routePlanner.getLastAddress(context));
            this.routePlanner.markAddressFailing(context);
            return this.limitedRetry(context);
        }
        if (this.delegate != null) {
            return this.delegate.onRequestException(context, request, error);
        }
        return false;
    }

    private boolean limitedRetry(HttpClientContext context) {
        if (this.getRetryCount(context) >= this.retryLimit) {
            throw new RateLimitException("Retry aborted, too many retries on ratelimit.");
        }
        return true;
    }

    private void setRetryCount(HttpClientContext context, int value) {
        RetryCount count = context.getAttribute(RETRY_COUNT_ATTRIBUTE, RetryCount.class);
        if (count == null) {
            count = new RetryCount();
            context.setAttribute(RETRY_COUNT_ATTRIBUTE, count);
        }
        count.value = value;
    }

    private int getRetryCount(HttpClientContext context) {
        RetryCount count = context.getAttribute(RETRY_COUNT_ATTRIBUTE, RetryCount.class);
        return count != null ? count.value : 0;
    }

    private static class RetryCount {
        private int value;

        private RetryCount() {
        }
    }
}

