/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AbstractAudioFrameBuffer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameRebuilder;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.ImmutableAudioFrame;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.ReferenceMutableAudioFrame;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.TerminatorAudioFrame;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public class NonAllocatingAudioFrameBuffer
extends AbstractAudioFrameBuffer {
    private static final Logger log = LoggerFactory.getLogger(NonAllocatingAudioFrameBuffer.class);
    private final int worstCaseFrameCount;
    private final ReferenceMutableAudioFrame[] frames;
    private final ReferenceMutableAudioFrame silentFrame;
    private final AtomicBoolean stopping;
    private MutableAudioFrame bridgeFrame;
    private final byte[] frameBuffer;
    private int firstFrame;
    private int frameCount;

    public NonAllocatingAudioFrameBuffer(int bufferDuration, AudioDataFormat format, AtomicBoolean stopping) {
        super(format);
        int maximumFrameCount = bufferDuration / (int)format.frameDuration() + 1;
        this.frames = NonAllocatingAudioFrameBuffer.createFrames(maximumFrameCount, format);
        this.silentFrame = NonAllocatingAudioFrameBuffer.createSilentFrame(format);
        this.frameBuffer = new byte[format.expectedChunkSize() * maximumFrameCount];
        this.worstCaseFrameCount = this.frameBuffer.length / format.maximumChunkSize();
        this.stopping = stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRemainingCapacity() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.frameCount == 0) {
                return this.worstCaseFrameCount;
            }
            int lastFrame = this.wrappedFrameIndex(this.firstFrame + this.frameCount - 1);
            int bufferHead = this.frames[this.firstFrame].getFrameOffset();
            int bufferTail = this.frames[lastFrame].getFrameEndOffset();
            int maximumFrameSize = this.format.maximumChunkSize();
            if (bufferHead < bufferTail) {
                return (this.frameBuffer.length - bufferTail) / maximumFrameSize + bufferHead / maximumFrameSize;
            }
            return (bufferHead - bufferTail) / maximumFrameSize;
        }
    }

    @Override
    public int getFullCapacity() {
        return this.worstCaseFrameCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(AudioFrame frame) throws InterruptedException {
        if (this.stopping != null && this.stopping.get()) {
            throw new InterruptedException();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.locked) {
                this.receivedFrames = true;
                if (this.clearOnInsert) {
                    this.clear();
                    this.clearOnInsert = false;
                }
                while (!this.attemptStore(frame)) {
                    this.synchronizer.wait();
                }
                this.synchronizer.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFrame provide() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.provide(this.getBridgeFrame())) {
                return this.unwrapBridgeFrame();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFrame provide(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.provide(this.getBridgeFrame(), timeout, unit)) {
                return this.unwrapBridgeFrame();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean provide(MutableAudioFrame targetFrame) {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.frameCount == 0) {
                if (this.terminateOnEmpty) {
                    this.popPendingTerminator(targetFrame);
                    this.synchronizer.notifyAll();
                    return true;
                }
                return false;
            }
            this.popFrame(targetFrame);
            this.synchronizer.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean provide(MutableAudioFrame targetFrame, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        long currentTime = System.nanoTime();
        long endTime = currentTime + unit.toMillis(timeout);
        Object object = this.synchronizer;
        synchronized (object) {
            while (this.frameCount == 0) {
                if (this.terminateOnEmpty) {
                    this.popPendingTerminator(targetFrame);
                    this.synchronizer.notifyAll();
                    return true;
                }
                this.synchronizer.wait(endTime - currentTime);
                currentTime = System.nanoTime();
                if (currentTime < endTime) continue;
                throw new TimeoutException();
            }
            this.popFrame(targetFrame);
            this.synchronizer.notifyAll();
            return true;
        }
    }

    private void popFrame(MutableAudioFrame targetFrame) {
        ReferenceMutableAudioFrame frame = this.frames[this.firstFrame];
        if (frame.getVolume() == 0) {
            this.silentFrame.setTimecode(frame.getTimecode());
            frame = this.silentFrame;
        }
        targetFrame.setTimecode(frame.getTimecode());
        targetFrame.setVolume(frame.getVolume());
        targetFrame.setTerminator(false);
        targetFrame.store(frame.getFrameBuffer(), frame.getFrameOffset(), frame.getDataLength());
        targetFrame.setFormat(frame.getFormat());
        targetFrame.setFlags(frame.getFlags());
        this.firstFrame = this.wrappedFrameIndex(this.firstFrame + 1);
        --this.frameCount;
    }

    private void popPendingTerminator(MutableAudioFrame frame) {
        this.terminateOnEmpty = false;
        this.terminated = true;
        frame.setTerminator(true);
        frame.setFlags(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.synchronizer;
        synchronized (object) {
            this.frameCount = 0;
        }
    }

    @Override
    public void rebuild(AudioFrameRebuilder rebuilder) {
        log.debug("Frame rebuild not supported on non-allocating frame buffer yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLastInputTimecode() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.clearOnInsert && this.frameCount > 0) {
                return this.frames[this.wrappedFrameIndex(this.firstFrame + this.frameCount - 1)].getTimecode();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean attemptStore(AudioFrame frame) {
        if (this.frameCount >= this.frames.length) {
            return false;
        }
        int frameLength = frame.getDataLength();
        int frameBufferLength = this.frameBuffer.length;
        if (this.frameCount == 0) {
            this.firstFrame = 0;
            if (frameLength > frameBufferLength) {
                throw new IllegalArgumentException("Frame is too big for buffer.");
            }
            this.store(frame, 0, 0, frameLength);
            return true;
        } else {
            int bufferTail;
            int lastFrame = this.wrappedFrameIndex(this.firstFrame + this.frameCount - 1);
            int nextFrame = this.wrappedFrameIndex(lastFrame + 1);
            int bufferHead = this.frames[this.firstFrame].getFrameOffset();
            if (bufferHead < (bufferTail = this.frames[lastFrame].getFrameEndOffset())) {
                if (bufferTail + frameLength <= frameBufferLength) {
                    this.store(frame, nextFrame, bufferTail, frameLength);
                    return true;
                } else {
                    if (bufferHead < frameLength) return false;
                    this.store(frame, nextFrame, 0, frameLength);
                }
                return true;
            } else {
                if (bufferTail + frameLength > bufferHead) return false;
                this.store(frame, nextFrame, bufferTail, frameLength);
            }
        }
        return true;
    }

    private int wrappedFrameIndex(int index) {
        int maximumFrameCount = this.frames.length;
        return index >= maximumFrameCount ? index - maximumFrameCount : index;
    }

    private void store(AudioFrame frame, int index, int frameOffset, int frameLength) {
        ReferenceMutableAudioFrame targetFrame = this.frames[index];
        targetFrame.setTimecode(frame.getTimecode());
        targetFrame.setVolume(frame.getVolume());
        targetFrame.setDataReference(this.frameBuffer, frameOffset, frameLength);
        targetFrame.setFlags(frame.getFlags());
        frame.getData(this.frameBuffer, frameOffset);
        ++this.frameCount;
    }

    private MutableAudioFrame getBridgeFrame() {
        if (this.bridgeFrame == null) {
            this.bridgeFrame = new MutableAudioFrame();
            this.bridgeFrame.setBuffer(ByteBuffer.allocate(this.format.maximumChunkSize()));
        }
        return this.bridgeFrame;
    }

    private AudioFrame unwrapBridgeFrame() {
        if (this.bridgeFrame.isTerminator()) {
            return TerminatorAudioFrame.INSTANCE;
        }
        return new ImmutableAudioFrame(this.bridgeFrame.getTimecode(), this.bridgeFrame.getData(), this.bridgeFrame.getVolume(), this.bridgeFrame.getFormat(), this.bridgeFrame.getFlags());
    }

    private static ReferenceMutableAudioFrame[] createFrames(int frameCount, AudioDataFormat format) {
        ReferenceMutableAudioFrame[] frames = new ReferenceMutableAudioFrame[frameCount];
        for (int i = 0; i < frames.length; ++i) {
            frames[i] = new ReferenceMutableAudioFrame();
            frames[i].setFormat(format);
        }
        return frames;
    }

    private static ReferenceMutableAudioFrame createSilentFrame(AudioDataFormat format) {
        ReferenceMutableAudioFrame frame = new ReferenceMutableAudioFrame();
        frame.setFormat(format);
        frame.setDataReference(format.silenceBytes(), 0, format.silenceBytes().length);
        frame.setVolume(0);
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void signalWaiters() {
        Object object = this.synchronizer;
        synchronized (object) {
            this.synchronizer.notifyAll();
        }
    }
}

