/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.info;

import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoProvider;

public class AudioTrackInfoBuilder
implements AudioTrackInfoProvider {
    private static final String UNKNOWN_TITLE = "Unknown title";
    private static final String UNKNOWN_ARTIST = "Unknown artist";
    private String title;
    private String author;
    private Long length;
    private String identifier;
    private String uri;
    private Boolean isStream;

    private AudioTrackInfoBuilder() {
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public AudioTrackInfoBuilder setTitle(String value) {
        this.title = DataFormatTools.defaultOnNull(value, this.title);
        return this;
    }

    public AudioTrackInfoBuilder setAuthor(String value) {
        this.author = DataFormatTools.defaultOnNull(value, this.author);
        return this;
    }

    public AudioTrackInfoBuilder setLength(Long value) {
        this.length = DataFormatTools.defaultOnNull(value, this.length);
        return this;
    }

    public AudioTrackInfoBuilder setIdentifier(String value) {
        this.identifier = DataFormatTools.defaultOnNull(value, this.identifier);
        return this;
    }

    public AudioTrackInfoBuilder setUri(String value) {
        this.uri = DataFormatTools.defaultOnNull(value, this.uri);
        return this;
    }

    public AudioTrackInfoBuilder setIsStream(Boolean stream) {
        this.isStream = stream;
        return this;
    }

    public AudioTrackInfoBuilder apply(AudioTrackInfoProvider provider) {
        if (provider == null) {
            return this;
        }
        return this.setTitle(provider.getTitle()).setAuthor(provider.getAuthor()).setLength(provider.getLength()).setIdentifier(provider.getIdentifier()).setUri(provider.getUri());
    }

    public AudioTrackInfo build() {
        long finalLength;
        return new AudioTrackInfo(this.title, this.author, finalLength, this.identifier, DataFormatTools.defaultOnNull(this.isStream, (finalLength = DataFormatTools.defaultOnNull(this.length, Long.MAX_VALUE).longValue()) == Long.MAX_VALUE), this.uri);
    }

    public static AudioTrackInfoBuilder create(AudioReference reference, SeekableInputStream stream) {
        AudioTrackInfoBuilder builder = new AudioTrackInfoBuilder().setAuthor(UNKNOWN_ARTIST).setTitle(UNKNOWN_TITLE).setLength(Long.MAX_VALUE);
        builder.apply(reference);
        if (stream != null) {
            for (AudioTrackInfoProvider provider : stream.getTrackInfoProviders()) {
                builder.apply(provider);
            }
        }
        return builder;
    }

    public static AudioTrackInfoBuilder empty() {
        return new AudioTrackInfoBuilder();
    }
}

