/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackState;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.PrimordialAudioTrackExecutor;

public abstract class BaseAudioTrack
implements InternalAudioTrack {
    private final PrimordialAudioTrackExecutor initialExecutor;
    private final AtomicBoolean executorAssigned;
    private final AtomicReference<AudioTrackExecutor> activeExecutor;
    protected final AudioTrackInfo trackInfo;
    protected final AtomicLong accurateDuration;
    private volatile Object userData;

    public BaseAudioTrack(AudioTrackInfo trackInfo) {
        this.initialExecutor = new PrimordialAudioTrackExecutor(trackInfo);
        this.executorAssigned = new AtomicBoolean();
        this.activeExecutor = new AtomicReference();
        this.trackInfo = trackInfo;
        this.accurateDuration = new AtomicLong();
    }

    @Override
    public void assignExecutor(AudioTrackExecutor executor, boolean applyPrimordialState) {
        if (this.executorAssigned.compareAndSet(false, true)) {
            if (applyPrimordialState) {
                this.initialExecutor.applyStateToExecutor(executor);
            }
        } else {
            throw new IllegalStateException("Cannot play the same instance of a track twice, use track.makeClone().");
        }
        this.activeExecutor.set(executor);
    }

    @Override
    public AudioTrackExecutor getActiveExecutor() {
        AudioTrackExecutor executor = this.activeExecutor.get();
        return executor != null ? executor : this.initialExecutor;
    }

    @Override
    public void stop() {
        AudioTrackExecutor executor = this.activeExecutor.getAndSet(null);
        if (executor != null) {
            this.initialExecutor.setPosition(executor.getPosition());
            executor.stop();
        }
    }

    @Override
    public AudioTrackState getState() {
        return this.getActiveExecutor().getState();
    }

    @Override
    public String getIdentifier() {
        return this.trackInfo.identifier;
    }

    @Override
    public boolean isSeekable() {
        return !this.trackInfo.isStream;
    }

    @Override
    public long getPosition() {
        return this.getActiveExecutor().getPosition();
    }

    @Override
    public void setPosition(long position) {
        this.getActiveExecutor().setPosition(position);
    }

    @Override
    public void setMarker(TrackMarker marker) {
        this.getActiveExecutor().setMarker(marker);
    }

    @Override
    public void addMarker(TrackMarker marker) {
        this.getActiveExecutor().addMarker(marker);
    }

    @Override
    public void removeMarker(TrackMarker marker) {
        this.getActiveExecutor().removeMarker(marker);
    }

    @Override
    public AudioFrame provide() {
        return this.getActiveExecutor().provide();
    }

    @Override
    public AudioFrame provide(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        return this.getActiveExecutor().provide(timeout, unit);
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame) {
        return this.getActiveExecutor().provide(targetFrame);
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        return this.getActiveExecutor().provide(targetFrame, timeout, unit);
    }

    @Override
    public AudioTrackInfo getInfo() {
        return this.trackInfo;
    }

    @Override
    public long getDuration() {
        long accurate = this.accurateDuration.get();
        if (accurate == 0L) {
            return this.trackInfo.length;
        }
        return accurate;
    }

    @Override
    public AudioTrack makeClone() {
        AudioTrack track = this.makeShallowClone();
        track.setUserData(this.userData);
        return track;
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return null;
    }

    @Override
    public AudioTrackExecutor createLocalExecutor(AudioPlayerManager playerManager) {
        return null;
    }

    @Override
    public void setUserData(Object userData) {
        this.userData = userData;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public <T> T getUserData(Class<T> klass) {
        Object data = this.userData;
        if (data != null && klass.isAssignableFrom(data.getClass())) {
            return (T)data;
        }
        return null;
    }

    protected AudioTrack makeShallowClone() {
        throw new UnsupportedOperationException();
    }
}

