/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import mods.thecomputerizer.shadow.org.apache.http.client.config.RequestConfig;
import mods.thecomputerizer.shadow.org.apache.http.impl.client.CloseableHttpClient;
import mods.thecomputerizer.shadow.org.apache.http.impl.client.HttpClientBuilder;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public abstract class AbstractHttpInterfaceManager
implements HttpInterfaceManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpInterfaceManager.class);
    private final HttpClientBuilder clientBuilder;
    private final Object lock;
    private boolean closed;
    private CloseableHttpClient sharedClient;
    private RequestConfig requestConfig;

    public AbstractHttpInterfaceManager(HttpClientBuilder clientBuilder, RequestConfig requestConfig) {
        this.clientBuilder = clientBuilder;
        this.requestConfig = requestConfig;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            if (this.sharedClient != null) {
                CloseableHttpClient client = this.sharedClient;
                this.sharedClient = null;
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.close();
            }
            catch (Exception e) {
                log.warn("Failed to close HTTP client.", e);
            }
            this.closed = false;
            this.requestConfig = configurator.apply(this.requestConfig);
            this.clientBuilder.setDefaultRequestConfig(this.requestConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.close();
            }
            catch (Exception e) {
                log.warn("Failed to close HTTP client.", e);
            }
            this.closed = false;
            configurator.accept(this.clientBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableHttpClient getSharedClient() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("Cannot get http client for a closed manager.");
            }
            if (this.sharedClient == null) {
                this.sharedClient = this.clientBuilder.build();
            }
            return this.sharedClient;
        }
    }
}

