/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;

public class OrderedExecutor {
    private final ExecutorService delegateService;
    private final ConcurrentMap<Object, BlockingQueue<Runnable>> states;

    public OrderedExecutor(ExecutorService delegateService) {
        this.delegateService = delegateService;
        this.states = new ConcurrentHashMap<Object, BlockingQueue<Runnable>>();
    }

    public Future<Void> submit(Object orderingKey, Runnable runnable) {
        RunnableFuture<Object> runnableFuture = this.newTaskFor(runnable, null);
        this.queueOrSubmit(new ChannelRunnable(orderingKey), runnableFuture);
        return runnableFuture;
    }

    public <T> Future<T> submit(Object orderingKey, Callable<T> callable) {
        RunnableFuture<T> runnableFuture = this.newTaskFor(callable);
        this.queueOrSubmit(new ChannelRunnable(orderingKey), runnableFuture);
        return runnableFuture;
    }

    private void queueOrSubmit(ChannelRunnable runnable, Runnable delegate) {
        LinkedBlockingQueue<Runnable> newQueue = new LinkedBlockingQueue<Runnable>();
        newQueue.add(delegate);
        BlockingQueue existing = this.states.putIfAbsent(runnable.key, newQueue);
        if (existing != null) {
            existing.add(delegate);
            if (this.states.putIfAbsent(runnable.key, existing) == null) {
                this.delegateService.execute(new ChannelRunnable(runnable.key));
            }
        } else {
            this.delegateService.execute(runnable);
        }
    }

    private <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new FutureTask<T>(runnable, value);
    }

    private <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new FutureTask<T>(callable);
    }

    private class ChannelRunnable
    implements Runnable {
        private final Object key;

        private ChannelRunnable(Object key) {
            this.key = key;
        }

        @Override
        public void run() {
            BlockingQueue queue = (BlockingQueue)OrderedExecutor.this.states.get(this.key);
            if (queue != null) {
                this.executeQueue(queue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeQueue(BlockingQueue<Runnable> queue) {
            Runnable next;
            while ((next = (Runnable)queue.poll()) != null) {
                boolean finished = false;
                try {
                    next.run();
                    finished = true;
                }
                finally {
                    if (finished) continue;
                    OrderedExecutor.this.delegateService.execute(new ChannelRunnable(this.key));
                }
            }
            OrderedExecutor.this.states.remove(this.key, queue);
        }
    }
}

