/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.youtube;

import java.net.URI;
import java.net.URISyntaxException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.youtube.BaseYoutubeHttpContextFilter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAccessTokenTracker;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.http.HttpContextRetryCounter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import mods.thecomputerizer.shadow.org.apache.http.HttpResponse;
import mods.thecomputerizer.shadow.org.apache.http.client.CookieStore;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.HttpRequestBase;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.HttpUriRequest;
import mods.thecomputerizer.shadow.org.apache.http.client.protocol.HttpClientContext;
import mods.thecomputerizer.shadow.org.apache.http.client.utils.URIBuilder;
import mods.thecomputerizer.shadow.org.apache.http.impl.client.BasicCookieStore;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public class YoutubeHttpContextFilter
extends BaseYoutubeHttpContextFilter {
    private static final Logger log = LoggerFactory.getLogger(YoutubeHttpContextFilter.class);
    private static final String ATTRIBUTE_RESET_RETRY = "isResetRetry";
    public static final String ATTRIBUTE_USER_AGENT_SPECIFIED = "clientUserAgent";
    private static final HttpContextRetryCounter retryCounter = new HttpContextRetryCounter("yt-token-retry");
    private YoutubeAccessTokenTracker tokenTracker;

    public void setTokenTracker(YoutubeAccessTokenTracker tokenTracker) {
        this.tokenTracker = tokenTracker;
    }

    @Override
    public void onContextOpen(HttpClientContext context) {
        CookieStore cookieStore = context.getCookieStore();
        if (cookieStore == null) {
            cookieStore = new BasicCookieStore();
            context.setCookieStore(cookieStore);
        }
        cookieStore.clear();
    }

    @Override
    public void onRequest(HttpClientContext context, HttpUriRequest request, boolean isRepetition) {
        String accessToken;
        if (!isRepetition) {
            context.removeAttribute(ATTRIBUTE_RESET_RETRY);
        }
        retryCounter.handleUpdate(context, isRepetition);
        if (this.tokenTracker.isTokenFetchContext(context)) {
            return;
        }
        String userAgent = context.getAttribute(ATTRIBUTE_USER_AGENT_SPECIFIED, String.class);
        if (context.getAttribute(ATTRIBUTE_USER_AGENT_SPECIFIED) != null) {
            request.setHeader("User-Agent", userAgent);
            request.setHeader("X-Goog-Visitor-Id", this.tokenTracker.getVisitorId());
            context.removeAttribute(ATTRIBUTE_USER_AGENT_SPECIFIED);
        }
        if (!DataFormatTools.isNullOrEmpty(accessToken = this.tokenTracker.getAccessToken())) {
            request.setHeader("Authorization", "Bearer " + accessToken);
        } else {
            try {
                URI uri = new URIBuilder(request.getURI()).setParameter("key", "AIzaSyA8eiZmM1FaDVjRy-df2KTyQ_vz_yYM39w").build();
                if (!(request instanceof HttpRequestBase)) {
                    throw new IllegalStateException("Cannot update request URI.");
                }
                ((HttpRequestBase)request).setURI(uri);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean onRequestResponse(HttpClientContext context, HttpUriRequest request, HttpResponse response) {
        if (response.getStatusLine().getStatusCode() == 429) {
            throw new FriendlyException("This IP address has been blocked by YouTube (429).", FriendlyException.Severity.COMMON, null);
        }
        if (this.tokenTracker.isTokenFetchContext(context) || retryCounter.getRetryCount(context) >= 1) {
            return false;
        }
        if (response.getStatusLine().getStatusCode() == 401) {
            this.tokenTracker.updateAccessToken();
            return true;
        }
        return false;
    }

    @Override
    public boolean onRequestException(HttpClientContext context, HttpUriRequest request, Throwable error) {
        if (HttpClientTools.isConnectionResetException(error) && context.getAttribute(ATTRIBUTE_RESET_RETRY) == null) {
            context.setAttribute(ATTRIBUTE_RESET_RETRY, true);
            return true;
        }
        return false;
    }
}

