/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.soundcloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.CloseableHttpResponse;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.HttpGet;
import mods.thecomputerizer.shadow.org.apache.http.client.protocol.HttpClientContext;
import mods.thecomputerizer.shadow.org.apache.http.util.EntityUtils;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;

public class SoundCloudClientIdTracker {
    private static final Logger log = LoggerFactory.getLogger(SoundCloudClientIdTracker.class);
    private static final String ID_FETCH_CONTEXT_ATTRIBUTE = "sc-raw";
    private static final long CLIENT_ID_REFRESH_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    private static final String PAGE_APP_SCRIPT_REGEX = "https://[A-Za-z0-9-.]+/assets/[a-f0-9-]+\\.js";
    private static final String APP_SCRIPT_CLIENT_ID_REGEX = "[^_]client_id:\"([a-zA-Z0-9-_]+)\"";
    private static final Pattern pageAppScriptPattern = Pattern.compile("https://[A-Za-z0-9-.]+/assets/[a-f0-9-]+\\.js");
    private static final Pattern appScriptClientIdPattern = Pattern.compile("[^_]client_id:\"([a-zA-Z0-9-_]+)\"");
    private static final int EXPECTED_CLIENT_SCRIPT_INDEX = 8;
    private final Object clientIdLock = new Object();
    private final HttpInterfaceManager httpInterfaceManager;
    private String clientId;
    private long lastClientIdUpdate;
    private int lastClientScriptIndex = 8;

    public SoundCloudClientIdTracker(HttpInterfaceManager httpInterfaceManager) {
        this.httpInterfaceManager = httpInterfaceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientId() {
        Object object = this.clientIdLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (now - this.lastClientIdUpdate < CLIENT_ID_REFRESH_INTERVAL) {
                log.debug("Client ID was recently updated, not updating again right away.");
                return;
            }
            this.lastClientIdUpdate = now;
            log.info("Updating SoundCloud client ID (current is {}).", (Object)this.clientId);
            try {
                this.clientId = this.findClientIdFromSite();
                log.info("Updating SoundCloud client ID succeeded, new ID is {}.", (Object)this.clientId);
            }
            catch (Exception e) {
                log.error("SoundCloud client ID update failed.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientId() {
        Object object = this.clientIdLock;
        synchronized (object) {
            if (this.clientId == null) {
                this.updateClientId();
            }
            return this.clientId;
        }
    }

    public boolean isIdFetchContext(HttpClientContext context) {
        return context.getAttribute(ID_FETCH_CONTEXT_ATTRIBUTE) == Boolean.TRUE;
    }

    private String findClientIdFromSite() throws IOException {
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            httpInterface.getContext().setAttribute(ID_FETCH_CONTEXT_ATTRIBUTE, true);
            List<String> scriptUrls = this.findScriptUrls(httpInterface);
            String string = this.findClientIdFromScripts(httpInterface, scriptUrls);
            return string;
        }
    }

    private List<String> findScriptUrls(HttpInterface httpInterface) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://soundcloud.com"));){
            HttpClientTools.assertSuccessWithContent(response, "main page response");
            String page = EntityUtils.toString(response.getEntity());
            Matcher matcher = pageAppScriptPattern.matcher(page);
            ArrayList<String> scriptUrls = new ArrayList<String>();
            while (matcher.find()) {
                scriptUrls.add(matcher.group());
            }
            ArrayList<String> arrayList = scriptUrls;
            return arrayList;
        }
    }

    private String findClientIdFromScripts(HttpInterface httpInterface, List<String> scriptUrls) throws IOException {
        for (int index : this.getIndicesByDistance(this.lastClientScriptIndex, scriptUrls.size())) {
            String url = scriptUrls.get(index);
            String clientId = this.findClientIdFromApplicationScript(httpInterface, url);
            if (clientId == null) continue;
            if (index != this.lastClientScriptIndex) {
                log.info("Last known client script index changed to {}, should update default for efficiency.", (Object)index);
                this.lastClientScriptIndex = index;
            }
            return clientId;
        }
        throw new IllegalStateException("Could not find client ID from " + scriptUrls.size() + " script candidates.");
    }

    private String findClientIdFromApplicationScript(HttpInterface httpInterface, String scriptUrl) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(scriptUrl));){
            HttpClientTools.assertSuccessWithContent(response, "application script response");
            String page = EntityUtils.toString(response.getEntity());
            Matcher clientIdMatcher = appScriptClientIdPattern.matcher(page);
            if (clientIdMatcher.find()) {
                String string = clientIdMatcher.group(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    private int[] getIndicesByDistance(int center, int size) {
        int maximumOffset = Math.max(size, center);
        int[] indices = new int[size];
        int indicesFilled = 0;
        for (int offset = 0; offset < maximumOffset; ++offset) {
            int backwardsIndex;
            int forwardIndex = center + offset;
            if (forwardIndex >= 0 && forwardIndex < size) {
                indices[indicesFilled++] = forwardIndex;
            }
            if (offset <= 0 || (backwardsIndex = center - offset) < 0 || backwardsIndex >= size) continue;
            indices[indicesFilled++] = backwardsIndex;
        }
        return indices;
    }
}

