/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.http;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Consumer;
import java.util.function.Function;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDescriptor;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerRegistry;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.ProbingAudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.http.HttpAudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.ThreadLocalHttpInterfaceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;
import mods.thecomputerizer.shadow.org.apache.http.client.config.RequestConfig;
import mods.thecomputerizer.shadow.org.apache.http.impl.client.HttpClientBuilder;

public class HttpAudioSourceManager
extends ProbingAudioSourceManager
implements HttpConfigurable {
    private final HttpInterfaceManager httpInterfaceManager = new ThreadLocalHttpInterfaceManager(HttpClientTools.createSharedCookiesHttpBuilder().setRedirectStrategy(new HttpClientTools.NoRedirectsStrategy()), HttpClientTools.DEFAULT_REQUEST_CONFIG);

    public HttpAudioSourceManager() {
        this(MediaContainerRegistry.DEFAULT_REGISTRY);
    }

    public HttpAudioSourceManager(MediaContainerRegistry containerRegistry) {
        super(containerRegistry);
    }

    @Override
    public String getSourceName() {
        return "http";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        AudioReference httpReference = HttpAudioSourceManager.getAsHttpReference(reference);
        if (httpReference == null) {
            return null;
        }
        if (httpReference.containerDescriptor != null) {
            return this.createTrack(AudioTrackInfoBuilder.create(reference, null).build(), httpReference.containerDescriptor);
        }
        return this.handleLoadResult(this.detectContainer(httpReference));
    }

    @Override
    protected AudioTrack createTrack(AudioTrackInfo trackInfo, MediaContainerDescriptor containerDescriptor) {
        return new HttpAudioTrack(trackInfo, containerDescriptor, this);
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    public static AudioReference getAsHttpReference(AudioReference reference) {
        if (reference.identifier.startsWith("https://") || reference.identifier.startsWith("http://")) {
            return reference;
        }
        if (reference.identifier.startsWith("icy://")) {
            return new AudioReference("http://" + reference.identifier.substring(6), reference.title);
        }
        return null;
    }

    private MediaContainerDetectionResult detectContainer(AudioReference reference) {
        MediaContainerDetectionResult result;
        try (HttpInterface httpInterface = this.getHttpInterface();){
            result = this.detectContainerWithClient(httpInterface, reference);
        }
        catch (IOException e) {
            throw new FriendlyException("Connecting to the URL failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MediaContainerDetectionResult detectContainerWithClient(HttpInterface httpInterface, AudioReference reference) throws IOException {
        try (PersistentHttpStream inputStream = new PersistentHttpStream(httpInterface, new URI(reference.identifier), Long.MAX_VALUE);){
            int statusCode = inputStream.checkStatusCode();
            String redirectUrl = HttpClientTools.getRedirectLocation(reference.identifier, inputStream.getCurrentResponse());
            if (redirectUrl != null) {
                MediaContainerDetectionResult mediaContainerDetectionResult = MediaContainerDetectionResult.refer(null, new AudioReference(redirectUrl, null));
                return mediaContainerDetectionResult;
            }
            if (statusCode == 404) {
                MediaContainerDetectionResult mediaContainerDetectionResult = null;
                return mediaContainerDetectionResult;
            }
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new FriendlyException("That URL is not playable.", FriendlyException.Severity.COMMON, new IllegalStateException("Status code " + statusCode));
            }
            MediaContainerHints hints = MediaContainerHints.from(HttpClientTools.getHeaderValue(inputStream.getCurrentResponse(), "Content-Type"), null);
            MediaContainerDetectionResult mediaContainerDetectionResult = new MediaContainerDetection(this.containerRegistry, reference, inputStream, hints).detectContainer();
            return mediaContainerDetectionResult;
        }
        catch (URISyntaxException e) {
            throw new FriendlyException("Not a valid URL.", FriendlyException.Severity.COMMON, e);
        }
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
        this.encodeTrackFactory(((HttpAudioTrack)track).getContainerTrackFactory(), output);
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        MediaContainerDescriptor containerTrackFactory = this.decodeTrackFactory(input);
        if (containerTrackFactory != null) {
            return new HttpAudioTrack(trackInfo, containerTrackFactory, this);
        }
        return null;
    }

    @Override
    public void shutdown() {
    }
}

