/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.bandcamp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mp3.Mp3AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.source.bandcamp.BandcampAudioSourceManager;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.CloseableHttpResponse;
import mods.thecomputerizer.shadow.org.apache.http.client.methods.HttpGet;
import mods.thecomputerizer.shadow.org.slf4j.Logger;
import mods.thecomputerizer.shadow.org.slf4j.LoggerFactory;
import org.apache.commons.io.IOUtils;

public class BandcampAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(BandcampAudioTrack.class);
    private final BandcampAudioSourceManager sourceManager;

    public BandcampAudioTrack(AudioTrackInfo trackInfo, BandcampAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            log.debug("Loading Bandcamp track page from URL: {}", (Object)this.trackInfo.identifier);
            String trackMediaUrl = this.getTrackMediaUrl(httpInterface);
            if (trackMediaUrl == null) {
                throw new FriendlyException("No supported formats for this track", FriendlyException.Severity.SUSPICIOUS, null);
            }
            log.debug("Starting Bandcamp track from URL: {}", (Object)trackMediaUrl);
            try (PersistentHttpStream stream = new PersistentHttpStream(httpInterface, new URI(trackMediaUrl), null);){
                this.processDelegate(new Mp3AudioTrack(this.trackInfo, stream), localExecutor);
            }
        }
    }

    private String getTrackMediaUrl(HttpInterface httpInterface) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(this.trackInfo.identifier));){
            HttpClientTools.assertSuccessWithContent(response, "track page");
            String responseText = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            JsonBrowser trackInfo = this.sourceManager.readTrackListInformation(responseText);
            String string = trackInfo.get("trackinfo").index(0).get("file").get("mp3-128").text();
            return string;
        }
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new BandcampAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

