/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.player;

import com.sedmelluq.discord.lavaplayer.natives.opus.OpusEncoder;
import java.util.HashMap;
import java.util.Map;

public class OpusEncoderConfiguration {
    private final Map<Integer, Integer> rawConfiguration = new HashMap<Integer, Integer>();

    public OpusEncoderConfiguration setVbr(boolean vbr) {
        this.configureRaw(4006, vbr ? 1 : 0);
        return this;
    }

    public OpusEncoderConfiguration setVbrConstraint(boolean constrained) {
        this.configureRaw(4020, constrained ? 1 : 0);
        return this;
    }

    public OpusEncoderConfiguration setBitrate(int bps) {
        this.configureRaw(4002, bps);
        return this;
    }

    public OpusEncoderConfiguration configureRaw(int request, int value) {
        this.rawConfiguration.put(request, value);
        return this;
    }

    public OpusEncoderConfiguration copyFrom(OpusEncoderConfiguration other) {
        other.rawConfiguration.putAll(this.rawConfiguration);
        return this;
    }

    public OpusEncoderConfiguration clear() {
        this.rawConfiguration.clear();
        return this;
    }

    public void apply(OpusEncoder encoder) {
        for (Map.Entry<Integer, Integer> entry : this.rawConfiguration.entrySet()) {
            int ret = encoder.configure(entry.getKey(), entry.getValue());
            if (ret == 0) continue;
            throw new IllegalStateException("configure encoder failed with error " + ret);
        }
    }
}

