/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.wav;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.wav.WavFileInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.wav.WavTrackProvider;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.wav.WaveFormatType;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;

public class WavFileLoader {
    static final int[] WAV_RIFF_HEADER = new int[]{82, 73, 70, 70, -1, -1, -1, -1, 87, 65, 86, 69};
    static final byte[] FORMAT_SUBTYPE_PCM = new byte[]{1, 0, 0, 0, 0, 0, 16, 0, -128, 0, 0, -86, 0, 56, -101, 113};
    private final SeekableInputStream inputStream;

    public WavFileLoader(SeekableInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public WavFileInfo parseHeaders() throws IOException {
        if (!MediaContainerDetection.checkNextBytes(this.inputStream, WAV_RIFF_HEADER, false)) {
            throw new IllegalStateException("Not a WAV header.");
        }
        InfoBuilder builder = new InfoBuilder();
        DataInputStream dataInput = new DataInputStream(this.inputStream);
        while (true) {
            String chunkName = this.readChunkName(dataInput);
            long chunkSize = Integer.toUnsignedLong(Integer.reverseBytes(dataInput.readInt()));
            if ("fmt ".equals(chunkName)) {
                int bytesRead = this.readFormatChunk(builder, dataInput);
                long chunkBytesRemaining = chunkSize - (long)bytesRead;
                if (chunkBytesRemaining <= 0L) continue;
                this.inputStream.skipFully(chunkBytesRemaining);
                continue;
            }
            if ("data".equals(chunkName)) {
                builder.sampleAreaSize = chunkSize;
                builder.startOffset = this.inputStream.getPosition();
                return builder.build();
            }
            this.inputStream.skipFully(chunkSize);
        }
    }

    private String readChunkName(DataInput dataInput) throws IOException {
        byte[] buffer = new byte[4];
        dataInput.readFully(buffer);
        return new String(buffer, StandardCharsets.US_ASCII);
    }

    private int readFormatChunk(InfoBuilder builder, DataInput dataInput) throws IOException {
        builder.setAudioFormat(Short.reverseBytes(dataInput.readShort()) & 0xFFFF);
        builder.channelCount = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        builder.sampleRate = Integer.reverseBytes(dataInput.readInt());
        dataInput.readInt();
        builder.blockAlign = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        builder.bitsPerSample = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        if (builder.formatType == WaveFormatType.WAVE_FORMAT_EXTENSIBLE) {
            dataInput.skipBytes(8);
            byte[] subFormat = new byte[16];
            dataInput.readFully(subFormat);
            InfoBuilder.access$1002(builder, subFormat);
            return 40;
        }
        return 16;
    }

    public WavTrackProvider loadTrack(AudioProcessingContext context) throws IOException {
        return new WavTrackProvider(context, this.inputStream, this.parseHeaders());
    }

    private static class InfoBuilder {
        private int audioFormat;
        private WaveFormatType formatType;
        private byte[] subFormat;
        private int channelCount;
        private int sampleRate;
        private int bitsPerSample;
        private int blockAlign;
        private long sampleAreaSize;
        private long startOffset;

        private InfoBuilder() {
        }

        private void setAudioFormat(int audioFormat) {
            this.audioFormat = audioFormat;
            this.formatType = WaveFormatType.getByCode(audioFormat);
        }

        private WavFileInfo build() {
            this.validateFormat();
            this.validateAlignment();
            return new WavFileInfo(this.channelCount, this.sampleRate, this.bitsPerSample, this.blockAlign, this.sampleAreaSize / (long)this.blockAlign, this.startOffset);
        }

        private void validateFormat() {
            if (this.formatType == WaveFormatType.WAVE_FORMAT_UNKNOWN) {
                throw new IllegalStateException("Invalid audio format " + this.audioFormat + ", must be 1 (PCM) or 65534 (WAVE_FORMAT_EXTENSIBLE)");
            }
            if (this.subFormat != null && !Arrays.equals(this.subFormat, FORMAT_SUBTYPE_PCM)) {
                throw new IllegalStateException("Invalid subformat " + Arrays.toString(this.subFormat));
            }
            if (this.channelCount < 1 || this.channelCount > 16) {
                throw new IllegalStateException("Invalid channel count: " + this.channelCount);
            }
            if (this.sampleRate < 100 || this.sampleRate > 384000) {
                throw new IllegalStateException("Invalid sample rate: " + this.sampleRate);
            }
            if (this.bitsPerSample != 16 && this.bitsPerSample != 24 && this.bitsPerSample != 32) {
                throw new IllegalStateException("Unsupported bits per sample: " + this.bitsPerSample);
            }
        }

        private void validateAlignment() {
            int minimumBlockAlign = this.channelCount * (this.bitsPerSample >> 3);
            if (this.blockAlign < minimumBlockAlign || this.blockAlign > minimumBlockAlign + 32) {
                throw new IllegalStateException("Block align is not valid: " + this.blockAlign);
            }
            if (this.blockAlign % (this.bitsPerSample >> 3) != 0) {
                throw new IllegalStateException("Block align is not a multiple of bits per sample: " + this.blockAlign);
            }
            if (this.sampleAreaSize < 0L) {
                throw new IllegalStateException("Negative sample area size: " + this.sampleAreaSize);
            }
        }

        static /* synthetic */ byte[] access$1002(InfoBuilder x0, byte[] x1) {
            x0.subFormat = x1;
            return x1;
        }
    }
}

