/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.vorbis;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggCodecHandler;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggMetadata;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggSeekPoint;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggStreamSizeInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackBlueprint;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.vorbis.OggVorbisTrackHandler;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.vorbis.VorbisCommentParser;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;

public class OggVorbisCodecHandler
implements OggCodecHandler {
    private static final int VORBIS_IDENTIFIER = ByteBuffer.wrap(new byte[]{1, 118, 111, 114}).getInt();
    private static final int MAX_COMMENTS_SAVED_LENGTH = 131072;
    private static final int MAX_COMMENTS_READ_LENGTH = 0x7800000;
    private static final byte[] COMMENT_PACKET_START = new byte[]{3, 118, 111, 114, 98, 105, 115};

    @Override
    public boolean isMatchingIdentifier(int identifier) {
        return identifier == VORBIS_IDENTIFIER;
    }

    @Override
    public int getMaximumFirstPacketLength() {
        return 64;
    }

    @Override
    public OggTrackBlueprint loadBlueprint(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        byte[] infoPacket = broker.extractBytes();
        this.loadCommentsHeader(stream, broker, true);
        ByteBuffer infoBuffer = ByteBuffer.wrap(infoPacket);
        int sampleRate = Integer.reverseBytes(infoBuffer.getInt(12));
        List<OggSeekPoint> seekPointList = stream.createSeekTable(sampleRate);
        if (seekPointList != null) {
            stream.setSeekPoints(seekPointList);
        }
        return new Blueprint(sampleRate, infoPacket, broker);
    }

    @Override
    public OggMetadata loadMetadata(OggPacketInputStream stream, DirectBufferStreamBroker broker) throws IOException {
        byte[] infoPacket = broker.extractBytes();
        this.loadCommentsHeader(stream, broker, false);
        ByteBuffer commentsPacket = broker.getBuffer();
        byte[] packetStart = new byte[COMMENT_PACKET_START.length];
        commentsPacket.get(packetStart);
        if (!Arrays.equals(packetStart, COMMENT_PACKET_START)) {
            return OggMetadata.EMPTY;
        }
        ByteBuffer infoBuffer = ByteBuffer.wrap(infoPacket);
        int sampleRate = Integer.reverseBytes(infoBuffer.getInt(12));
        OggStreamSizeInfo sizeInfo = stream.seekForSizeInfo(sampleRate);
        return new OggMetadata(VorbisCommentParser.parse(commentsPacket, broker.isTruncated()), sizeInfo != null ? sizeInfo.getDuration() : Long.MAX_VALUE);
    }

    private void loadCommentsHeader(OggPacketInputStream stream, DirectBufferStreamBroker broker, boolean skip) throws IOException {
        if (!stream.startNewPacket()) {
            throw new IllegalStateException("No comments packet in track.");
        }
        if (!broker.consumeNext(stream, skip ? 0 : 131072, 0x7800000) && !stream.isPacketComplete()) {
            throw new IllegalStateException("Vorbis comments header packet longer than allowed.");
        }
    }

    private static class Blueprint
    implements OggTrackBlueprint {
        private final int sampleRate;
        private final byte[] infoPacket;
        private final DirectBufferStreamBroker broker;

        private Blueprint(int sampleRate, byte[] infoPacket, DirectBufferStreamBroker broker) {
            this.sampleRate = sampleRate;
            this.infoPacket = infoPacket;
            this.broker = broker;
        }

        @Override
        public OggTrackHandler loadTrackHandler(OggPacketInputStream stream) {
            return new OggVorbisTrackHandler(this.infoPacket, stream, this.broker);
        }

        @Override
        public int getSampleRate() {
            return this.sampleRate;
        }
    }
}

