/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.opus;

import java.io.IOException;
import java.nio.ByteBuffer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.common.OpusPacketRouter;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackHandler;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;

public class OggOpusTrackHandler
implements OggTrackHandler {
    private final OggPacketInputStream packetInputStream;
    private final DirectBufferStreamBroker broker;
    private final int channelCount;
    private final int sampleRate;
    private OpusPacketRouter opusPacketRouter;

    public OggOpusTrackHandler(OggPacketInputStream packetInputStream, DirectBufferStreamBroker broker, int channelCount, int sampleRate) {
        this.packetInputStream = packetInputStream;
        this.broker = broker;
        this.channelCount = channelCount;
        this.sampleRate = sampleRate;
    }

    @Override
    public void initialise(AudioProcessingContext context, long timecode, long desiredTimecode) {
        this.opusPacketRouter = new OpusPacketRouter(context, this.sampleRate, this.channelCount);
        this.opusPacketRouter.seekPerformed(desiredTimecode, timecode);
    }

    @Override
    public void provideFrames() throws InterruptedException {
        try {
            while (this.packetInputStream.startNewPacket()) {
                this.broker.consumeNext(this.packetInputStream, Integer.MAX_VALUE, Integer.MAX_VALUE);
                ByteBuffer buffer = this.broker.getBuffer();
                if (buffer.remaining() <= 0) continue;
                this.opusPacketRouter.process(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void seekToTimecode(long timecode) {
        try {
            this.opusPacketRouter.seekPerformed(timecode, this.packetInputStream.seek(timecode));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.opusPacketRouter != null) {
            this.opusPacketRouter.close();
        }
    }
}

