/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.stream.Stream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggCodecHandler;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggMetadata;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackBlueprint;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.flac.OggFlacCodecHandler;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.opus.OggOpusCodecHandler;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.ogg.vorbis.OggVorbisCodecHandler;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;

public class OggTrackLoader {
    private static final int THEORA_VIDEO = ByteBuffer.wrap(new byte[]{-128, 116, 104, 101}).getInt();
    private static final OggCodecHandler[] TRACK_PROVIDERS = new OggCodecHandler[]{new OggOpusCodecHandler(), new OggFlacCodecHandler(), new OggVorbisCodecHandler()};
    private static final int MAXIMUM_FIRST_PACKET_LENGTH = Stream.of(TRACK_PROVIDERS).mapToInt(OggCodecHandler::getMaximumFirstPacketLength).max().getAsInt();

    public static OggTrackBlueprint loadTrackBlueprint(OggPacketInputStream packetInputStream) throws IOException {
        CodecDetection result = OggTrackLoader.detectCodec(packetInputStream);
        return result != null ? result.provider.loadBlueprint(packetInputStream, result.broker) : null;
    }

    public static OggMetadata loadMetadata(OggPacketInputStream packetInputStream) throws IOException {
        CodecDetection result = OggTrackLoader.detectCodec(packetInputStream);
        return result != null ? result.provider.loadMetadata(packetInputStream, result.broker) : null;
    }

    private static CodecDetection detectCodec(OggPacketInputStream stream) throws IOException {
        if (!stream.startNewTrack() || !stream.startNewPacket()) {
            return null;
        }
        DirectBufferStreamBroker broker = new DirectBufferStreamBroker(1024);
        int maximumLength = MAXIMUM_FIRST_PACKET_LENGTH + 1;
        if (!broker.consumeNext(stream, maximumLength, maximumLength)) {
            throw new IOException("First packet is too large for any known OGG codec.");
        }
        int headerIdentifier = broker.getBuffer().getInt();
        for (OggCodecHandler trackProvider : TRACK_PROVIDERS) {
            if (!trackProvider.isMatchingIdentifier(headerIdentifier)) continue;
            return new CodecDetection(trackProvider, broker);
        }
        throw new IllegalStateException("Unsupported track in OGG stream.");
    }

    private static class CodecDetection {
        private final OggCodecHandler provider;
        private final DirectBufferStreamBroker broker;

        private CodecDetection(OggCodecHandler provider, DirectBufferStreamBroker broker) {
            this.provider = provider;
            this.broker = broker;
        }
    }
}

