/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpegts;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.GreedyInputStream;

public class PesPacketInputStream
extends InputStream {
    private static final byte[] SYNC_BYTES = new byte[]{0, 0, 1};
    private final InputStream inputStream;
    private final byte[] lengthBufferBytes;
    private final ByteBuffer lengthBuffer;
    private int packetBytesLeft;

    public PesPacketInputStream(InputStream inputStream) {
        this.inputStream = new GreedyInputStream(inputStream);
        this.lengthBufferBytes = new byte[2];
        this.lengthBuffer = ByteBuffer.wrap(this.lengthBufferBytes);
    }

    private boolean makeBytesAvailable() throws IOException {
        int streamByte;
        if (this.packetBytesLeft > 0) {
            return true;
        }
        int matched = 0;
        boolean packetFound = false;
        while (!packetFound && (streamByte = this.inputStream.read()) != -1) {
            if (streamByte == SYNC_BYTES[matched]) {
                if (++matched != SYNC_BYTES.length) continue;
                matched = 0;
                packetFound = this.processPacketHeader();
                continue;
            }
            matched = 0;
        }
        return packetFound;
    }

    private boolean processPacketHeader() throws IOException {
        if (this.inputStream.read() == -1 || this.inputStream.read(this.lengthBufferBytes) != this.lengthBufferBytes.length) {
            return false;
        }
        short length = this.lengthBuffer.getShort(0);
        if (this.inputStream.skip(2L) != 2L) {
            return false;
        }
        int headerLength = this.inputStream.read();
        if (headerLength == -1 || this.inputStream.skip(headerLength) != (long)headerLength) {
            return false;
        }
        this.packetBytesLeft = length - 3 - headerLength;
        return this.packetBytesLeft > 0;
    }

    @Override
    public int read() throws IOException {
        if (!this.makeBytesAvailable()) {
            return -1;
        }
        int result = this.inputStream.read();
        if (result >= 0) {
            --this.packetBytesLeft;
        }
        return result;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (!this.makeBytesAvailable()) {
            return -1;
        }
        int chunk = Math.min(this.packetBytesLeft, length);
        int result = this.inputStream.read(buffer, offset, chunk);
        if (result > 0) {
            this.packetBytesLeft -= result;
        }
        return result;
    }

    @Override
    public int available() throws IOException {
        return this.packetBytesLeft;
    }
}

