/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpeg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackConsumer;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegFileTrackProvider;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegParseStopChecker;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegReader;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegSectionInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegVersionedSectionInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.fragmented.MpegFragmentedFileTrackProvider;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.mpeg.reader.standard.MpegStandardFileTrackProvider;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;

public class MpegFileLoader {
    private final List<MpegTrackInfo> tracks = new ArrayList<MpegTrackInfo>();
    private final MpegFragmentedFileTrackProvider fragmentedFileReader;
    private final MpegStandardFileTrackProvider standardFileReader;
    private final MpegReader reader;
    private final MpegSectionInfo root;
    private final Map<String, Object> metadata;
    private byte[] lastEventMessage;

    public MpegFileLoader(SeekableInputStream inputStream) {
        this.reader = new MpegReader(inputStream);
        this.root = new MpegSectionInfo(0L, inputStream.getContentLength(), "root");
        this.fragmentedFileReader = new MpegFragmentedFileTrackProvider(this.reader, this.root);
        this.standardFileReader = new MpegStandardFileTrackProvider(this.reader);
        this.metadata = new HashMap<String, Object>();
    }

    public List<MpegTrackInfo> getTrackList() {
        return this.tracks;
    }

    public void parseHeaders() {
        try {
            AtomicBoolean movieBoxSeen = new AtomicBoolean();
            this.reader.in(this.root).handle("moov", moov -> {
                movieBoxSeen.set(true);
                this.reader.in(moov).handle("trak", this::parseTrackInfo).handle("mvex", this.fragmentedFileReader::parseMovieExtended).handle("udta", this::parseMetadata).run();
            }).handleVersioned("emsg", this::parseEventMessage).handleVersioned("sidx", true, this.fragmentedFileReader::parseSegmentIndex).stopChecker(this.getRootStopChecker(movieBoxSeen)).run();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTextMetadata(String name) {
        Object data = this.metadata.get(name);
        return data instanceof String ? (String)data : null;
    }

    public byte[] getLastEventMessage() {
        return this.lastEventMessage;
    }

    private void parseMetadata(MpegSectionInfo udta) throws IOException {
        this.reader.in(udta).handleVersioned("meta", meta -> this.reader.in(meta).handle("ilst", ilst -> {
            MpegSectionInfo entry;
            while ((entry = this.reader.nextChild(ilst)) != null) {
                this.parseMetadataEntry(entry);
            }
        }).run()).run();
    }

    private void parseMetadataEntry(MpegSectionInfo entry) throws IOException {
        MpegSectionInfo dataHeader = this.reader.nextChild(entry);
        if (dataHeader != null && "data".equals(dataHeader.type)) {
            MpegVersionedSectionInfo data = this.reader.parseFlags(dataHeader);
            this.reader.data.readInt();
            if (data.flags == 1) {
                this.storeMetadata(entry.type, this.reader.readUtfString((int)data.length - 16));
            }
        }
        this.reader.skip(entry);
    }

    private void storeMetadata(String code, Object value) {
        String name = MpegFileLoader.getMetadataName(code);
        if (name != null && value != null) {
            this.metadata.put(name, value);
        }
    }

    private static String getMetadataName(String code) {
        switch (code.toLowerCase()) {
            case "\u00a9art": {
                return "Artist";
            }
            case "\u00a9nam": {
                return "Title";
            }
        }
        return null;
    }

    private MpegParseStopChecker getRootStopChecker(AtomicBoolean movieBoxSeen) {
        return (child, start) -> {
            if (!start && "sidx".equals(child.type)) {
                return true;
            }
            if (!start && "emsg".equals(child.type)) {
                return movieBoxSeen.get();
            }
            if (start && ("mdat".equals(child.type) || "free".equals(child.type))) {
                return movieBoxSeen.get();
            }
            return false;
        };
    }

    public MpegFileTrackProvider loadReader(MpegTrackConsumer consumer) {
        if (this.fragmentedFileReader.initialise(consumer)) {
            return this.fragmentedFileReader;
        }
        if (this.standardFileReader.initialise(consumer)) {
            return this.standardFileReader;
        }
        return null;
    }

    private void parseTrackInfo(MpegSectionInfo trak) throws IOException {
        MpegTrackInfo.Builder trackInfo = new MpegTrackInfo.Builder();
        this.reader.in(trak).handleVersioned("tkhd", tkhd -> {
            this.reader.data.skipBytes(tkhd.version == 1 ? 16 : 8);
            trackInfo.setTrackId(this.reader.data.readInt());
        }).handle("mdia", mdia -> this.reader.in(mdia).handleVersioned("hdlr", hdlr -> {
            this.reader.data.skipBytes(4);
            trackInfo.setHandler(this.reader.readFourCC());
        }).handleVersioned("mdhd", mdhd -> this.standardFileReader.readMediaHeaders(mdhd, trackInfo.getTrackId())).handle("minf", minf -> this.reader.in(minf).handle("stbl", stbl -> {
            MpegReader.Chain chain = this.reader.in(stbl);
            this.parseTrackCodecInfo(chain, trackInfo);
            this.standardFileReader.attachSampleTableParsers(chain, trackInfo.getTrackId());
            chain.run();
        }).run()).run()).run();
        this.tracks.add(trackInfo.build());
    }

    private void parseTrackCodecInfo(MpegReader.Chain chain, MpegTrackInfo.Builder trackInfo) {
        chain.handleVersioned("stsd", stsd -> {
            int entryCount = this.reader.data.readInt();
            if (entryCount > 0) {
                MpegSectionInfo codec = this.reader.nextChild(stsd);
                trackInfo.setCodecName(codec.type);
                if ("soun".equals(trackInfo.getHandler())) {
                    this.parseSoundTrackCodec(codec, trackInfo);
                }
            }
        });
    }

    private void parseSoundTrackCodec(MpegSectionInfo codec, MpegTrackInfo.Builder trackInfo) throws IOException {
        this.reader.parseFlags(codec);
        this.reader.data.skipBytes(4);
        int version = this.reader.data.readUnsignedShort();
        switch (version) {
            case 0: 
            case 1: {
                this.reader.data.skipBytes(6);
                trackInfo.setChannelCount(this.reader.data.readUnsignedShort());
                this.reader.data.readUnsignedShort();
                this.reader.data.readUnsignedShort();
                trackInfo.setSampleRate(this.reader.data.readInt());
                this.reader.data.readUnsignedShort();
                break;
            }
            case 2: {
                this.reader.data.skipBytes(6);
                this.reader.data.readUnsignedShort();
                this.reader.data.readUnsignedShort();
                this.reader.data.readShort();
                this.reader.data.readUnsignedShort();
                this.reader.data.readInt();
                this.reader.data.skipBytes(2);
                this.reader.data.readUnsignedShort();
                trackInfo.setSampleRate((int)this.reader.data.readDouble());
                trackInfo.setChannelCount(this.reader.data.readInt());
            }
        }
        MpegSectionInfo esds = this.reader.nextChild(codec);
        if (esds != null && "esds".equals(esds.type)) {
            trackInfo.setDecoderConfig(this.parseDecoderConfig(esds));
        }
    }

    private byte[] parseDecoderConfig(MpegSectionInfo esds) throws IOException {
        this.reader.parseFlags(esds);
        int descriptorTag = this.reader.data.readUnsignedByte();
        if (descriptorTag == 3) {
            if (this.reader.readCompressedInt() < 20) {
                return null;
            }
            this.reader.data.skipBytes(3);
        } else {
            this.reader.data.skipBytes(2);
        }
        if (this.reader.data.readUnsignedByte() != 4 || this.reader.readCompressedInt() < 15) {
            return null;
        }
        this.reader.data.skipBytes(13);
        if (this.reader.data.readUnsignedByte() != 5) {
            return null;
        }
        int decoderConfigLength = this.reader.readCompressedInt();
        if (decoderConfigLength > 8) {
            return null;
        }
        byte[] decoderConfig = new byte[decoderConfigLength];
        this.reader.data.readFully(decoderConfig);
        return decoderConfig;
    }

    private void parseEventMessage(MpegSectionInfo emsg) throws IOException {
        this.reader.readTerminatedString();
        this.reader.readTerminatedString();
        this.reader.data.readInt();
        this.reader.data.readInt();
        this.reader.data.readInt();
        int remaining = (int)(emsg.offset + emsg.length - this.reader.seek.getPosition());
        this.lastEventMessage = new byte[remaining];
        this.reader.data.readFully(this.lastEventMessage);
    }
}

