/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.matroska.format;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaEbmlReader;

public enum MatroskaElementType {
    Ebml(DataType.MASTER, new int[]{26, 69, 223, 163}),
    DocType(DataType.STRING, new int[]{66, 130}),
    Segment(DataType.MASTER, new int[]{24, 83, 128, 103}),
    SeekHead(DataType.MASTER, new int[]{17, 77, 155, 116}),
    Seek(DataType.MASTER, new int[]{77, 187}),
    SeekId(DataType.BINARY, new int[]{83, 171}),
    SeekPosition(DataType.UNSIGNED_INTEGER, new int[]{83, 172}),
    Info(DataType.MASTER, new int[]{21, 73, 169, 102}),
    Tags(DataType.MASTER, new int[]{18, 84, 195, 103}),
    Tag(DataType.MASTER, new int[]{115, 115}),
    SimpleTag(DataType.MASTER, new int[]{103, 200}),
    Duration(DataType.FLOAT, new int[]{68, 137}),
    TimecodeScale(DataType.UNSIGNED_INTEGER, new int[]{42, 215, 177}),
    Cluster(DataType.MASTER, new int[]{31, 67, 182, 117}),
    Timecode(DataType.UNSIGNED_INTEGER, new int[]{231}),
    SimpleBlock(DataType.BINARY, new int[]{163}),
    BlockGroup(DataType.MASTER, new int[]{160}),
    Block(DataType.BINARY, new int[]{161}),
    BlockDuration(DataType.UNSIGNED_INTEGER, new int[]{155}),
    ReferenceBlock(DataType.SIGNED_INTEGER, new int[]{251}),
    Tracks(DataType.MASTER, new int[]{22, 84, 174, 107}),
    TrackEntry(DataType.MASTER, new int[]{174}),
    TrackNumber(DataType.UNSIGNED_INTEGER, new int[]{215}),
    TrackUid(DataType.UNSIGNED_INTEGER, new int[]{115, 197}),
    TrackType(DataType.UNSIGNED_INTEGER, new int[]{131}),
    Name(DataType.UTF8_STRING, new int[]{83, 110}),
    CodecId(DataType.STRING, new int[]{134}),
    CodecPrivate(DataType.BINARY, new int[]{99, 162}),
    Audio(DataType.MASTER, new int[]{225}),
    SamplingFrequency(DataType.FLOAT, new int[]{181}),
    OutputSamplingFrequency(DataType.FLOAT, new int[]{120, 181}),
    Channels(DataType.UNSIGNED_INTEGER, new int[]{159}),
    BitDepth(DataType.UNSIGNED_INTEGER, new int[]{98, 100}),
    Cues(DataType.MASTER, new int[]{28, 83, 187, 107}),
    CuePoint(DataType.MASTER, new int[]{187}),
    CueTime(DataType.UNSIGNED_INTEGER, new int[]{179}),
    CueTrackPositions(DataType.MASTER, new int[]{183}),
    CueTrack(DataType.UNSIGNED_INTEGER, new int[]{247}),
    CueClusterPosition(DataType.UNSIGNED_INTEGER, new int[]{241}),
    Title(DataType.STRING, new int[]{123, 169}),
    TagName(DataType.STRING, new int[]{69, 163}),
    TagString(DataType.STRING, new int[]{68, 135}),
    Unknown(DataType.BINARY, new int[0]);

    private static final Map<Long, MatroskaElementType> mapping;
    public final byte[] bytes;
    public final long id;
    public final DataType dataType;

    private MatroskaElementType(DataType dataType, int[] integers) {
        this.dataType = dataType;
        this.bytes = MatroskaElementType.asByteArray(integers);
        this.id = this.bytes.length > 0 ? MatroskaEbmlReader.readEbmlInteger(ByteBuffer.wrap(this.bytes), null) : -1L;
    }

    private static byte[] asByteArray(int[] integers) {
        byte[] bytes = new byte[integers.length];
        for (int i = 0; i < integers.length; ++i) {
            bytes[i] = (byte)integers[i];
        }
        return bytes;
    }

    public static MatroskaElementType find(long id) {
        MatroskaElementType code = mapping.get(id);
        if (code == null) {
            code = Unknown;
        }
        return code;
    }

    static {
        HashMap<Long, MatroskaElementType> codeMapping = new HashMap<Long, MatroskaElementType>();
        for (MatroskaElementType code : (MatroskaElementType[])MatroskaElementType.class.getEnumConstants()) {
            if (code == Unknown) continue;
            codeMapping.put(code.id, code);
        }
        mapping = codeMapping;
    }

    public static enum DataType {
        MASTER,
        UNSIGNED_INTEGER,
        SIGNED_INTEGER,
        STRING,
        UTF8_STRING,
        BINARY,
        FLOAT,
        DATE;

    }
}

