/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac.frame;

import java.io.IOException;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac.FlacStreamInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.container.flac.frame.FlacFrameInfo;
import mods.thecomputerizer.shadow.com.sedmelluq.discord.lavaplayer.tools.io.BitStreamReader;

public class FlacSubFrameReader {
    private static final Encoding[] encodingMapping = new Encoding[]{Encoding.LPC, null, Encoding.FIXED, null, null, Encoding.VERBATIM, Encoding.CONSTANT};

    public static void readSubFrame(BitStreamReader reader, FlacStreamInfo streamInfo, FlacFrameInfo frameInfo, int[] sampleBuffer, int channel, int[] temporaryBuffer) throws IOException {
        if (reader.asInteger(1) == 1) {
            throw new IllegalStateException("Subframe header must start with 0 bit.");
        }
        boolean isDeltaChannel = frameInfo.channelDelta.deltaChannel == channel;
        int subFrameDescriptor = reader.asInteger(6);
        int wastedBitCount = reader.asInteger(1) == 1 ? reader.readAllZeroes() + 1 : 0;
        int bitsPerSample = streamInfo.bitsPerSample - wastedBitCount + (isDeltaChannel ? 1 : 0);
        FlacSubFrameReader.readSubFrameSamples(reader, subFrameDescriptor, bitsPerSample, sampleBuffer, frameInfo.sampleCount, temporaryBuffer);
        if (wastedBitCount > 0) {
            int i = 0;
            while (i < frameInfo.sampleCount) {
                int n = i++;
                sampleBuffer[n] = sampleBuffer[n] << wastedBitCount;
            }
        }
    }

    private static void readSubFrameSamples(BitStreamReader reader, int subFrameDescriptor, int bitsPerSample, int[] sampleBuffer, int sampleCount, int[] temporaryBuffer) throws IOException {
        Encoding subframeEncoding = encodingMapping[Integer.numberOfLeadingZeros(subFrameDescriptor) - 26];
        if (subframeEncoding == null) {
            throw new RuntimeException("Invalid subframe type.");
        }
        if (subframeEncoding == Encoding.LPC) {
            FlacSubFrameReader.readSubFrameLpcData(reader, (subFrameDescriptor & 0x1F) + 1, bitsPerSample, sampleBuffer, sampleCount, temporaryBuffer);
        } else if (subframeEncoding == Encoding.FIXED) {
            FlacSubFrameReader.readSubFrameFixedData(reader, subFrameDescriptor & 7, bitsPerSample, sampleBuffer, sampleCount);
        } else if (subframeEncoding == Encoding.VERBATIM) {
            FlacSubFrameReader.readSubFrameVerbatimData(reader, bitsPerSample, sampleBuffer, sampleCount);
        } else if (subframeEncoding == Encoding.CONSTANT) {
            FlacSubFrameReader.readSubFrameConstantData(reader, bitsPerSample, sampleBuffer, sampleCount);
        }
    }

    private static void readSubFrameConstantData(BitStreamReader reader, int bitsPerSample, int[] sampleBuffer, int sampleCount) throws IOException {
        int value = reader.asSignedInteger(bitsPerSample);
        for (int i = 0; i < sampleCount; ++i) {
            sampleBuffer[i] = value;
        }
    }

    private static void readSubFrameVerbatimData(BitStreamReader reader, int bitsPerSample, int[] sampleBuffer, int sampleCount) throws IOException {
        for (int i = 0; i < sampleCount; ++i) {
            sampleBuffer[i] = reader.asSignedInteger(bitsPerSample);
        }
    }

    private static void readSubFrameFixedData(BitStreamReader reader, int order, int bitsPerSample, int[] sampleBuffer, int sampleCount) throws IOException {
        for (int i = 0; i < order; ++i) {
            sampleBuffer[i] = reader.asSignedInteger(bitsPerSample);
        }
        FlacSubFrameReader.readResidual(reader, order, sampleBuffer, order, sampleCount);
        FlacSubFrameReader.restoreFixedSignal(sampleBuffer, sampleCount, order);
    }

    private static void restoreFixedSignal(int[] buffer, int sampleCount, int order) {
        switch (order) {
            case 1: {
                for (int i = order; i < sampleCount; ++i) {
                    int n = i;
                    buffer[n] = buffer[n] + buffer[i - 1];
                }
                break;
            }
            case 2: {
                for (int i = order; i < sampleCount; ++i) {
                    int n = i;
                    buffer[n] = buffer[n] + ((buffer[i - 1] << 1) - buffer[i - 2]);
                }
                break;
            }
            case 3: {
                for (int i = order; i < sampleCount; ++i) {
                    int n = i;
                    buffer[n] = buffer[n] + ((buffer[i - 1] - buffer[i - 2] << 1) + (buffer[i - 1] - buffer[i - 2]) + buffer[i - 3]);
                }
                break;
            }
            case 4: {
                for (int i = order; i < sampleCount; ++i) {
                    int n = i;
                    buffer[n] = buffer[n] + ((buffer[i - 1] + buffer[i - 3] << 2) - ((buffer[i - 2] << 2) + (buffer[i - 2] << 1)) - buffer[i - 4]);
                }
                break;
            }
        }
    }

    private static void readSubFrameLpcData(BitStreamReader reader, int order, int bitsPerSample, int[] sampleBuffer, int sampleCount, int[] coefficients) throws IOException {
        for (int i = 0; i < order; ++i) {
            sampleBuffer[i] = reader.asSignedInteger(bitsPerSample);
        }
        int precision = reader.asInteger(4) + 1;
        int shift = reader.asInteger(5);
        for (int i = 0; i < order; ++i) {
            coefficients[i] = reader.asSignedInteger(precision);
        }
        FlacSubFrameReader.readResidual(reader, order, sampleBuffer, order, sampleCount);
        FlacSubFrameReader.restoreLpcSignal(sampleBuffer, sampleCount, order, shift, coefficients);
    }

    private static void restoreLpcSignal(int[] buffer, int sampleCount, int order, int shift, int[] coefficients) {
        int i = order;
        while (i < sampleCount) {
            long sum = 0L;
            for (int j = 0; j < order; ++j) {
                sum += (long)coefficients[j] * (long)buffer[i - j - 1];
            }
            int n = i++;
            buffer[n] = buffer[n] + (int)(sum >> shift);
        }
    }

    private static void readResidual(BitStreamReader reader, int order, int[] buffer, int startOffset, int endOffset) throws IOException {
        int method = reader.asInteger(2);
        if (method > 1) {
            throw new RuntimeException("Invalid residual coding method " + method);
        }
        int partitionOrder = reader.asInteger(4);
        int partitions = 1 << partitionOrder;
        int partitionSamples = partitionOrder > 0 ? endOffset >> partitionOrder : endOffset - order;
        int parameterLength = method == 0 ? 4 : 5;
        int parameterMaximum = (1 << parameterLength) - 1;
        int sample = startOffset;
        for (int partition = 0; partition < partitions; ++partition) {
            int value;
            int parameter = reader.asInteger(parameterLength);
            int n = value = partitionOrder == 0 || partition > 0 ? 0 : order;
            if (parameter < parameterMaximum) {
                value = partitionSamples - value;
                FlacSubFrameReader.readResidualBlock(reader, buffer, sample, sample + value, parameter);
                sample += value;
                continue;
            }
            parameter = reader.asInteger(5);
            int i = value;
            while (i < partitionSamples) {
                buffer[sample] = reader.asSignedInteger(parameter);
                ++i;
                ++sample;
            }
        }
    }

    private static void readResidualBlock(BitStreamReader reader, int[] buffer, int offset, int endOffset, int parameter) throws IOException {
        for (int i = offset; i < endOffset; ++i) {
            int lowOrderSigned = reader.readAllZeroes() << parameter | reader.asInteger(parameter);
            buffer[i] = (lowOrderSigned & 1) == 0 ? lowOrderSigned >> 1 : -(lowOrderSigned >> 1) - 1;
        }
    }

    private static enum Encoding {
        CONSTANT,
        VERBATIM,
        FIXED,
        LPC;

    }
}

