/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.server;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.ResourceContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerBiome;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerCommand;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerMob;
import mods.thecomputerizer.musictriggers.api.network.MTNetwork;
import mods.thecomputerizer.musictriggers.api.network.MessageCurrentStructure;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.structure.StructureAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.ChampionsAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.InfernalMobsAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.ModHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.ServerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;

public class TriggerContextServer
extends TriggerContext {
    private StructureAPI<?> structure;
    private String getPreviousStructureID = "?";
    private String previousStructureName = "?";

    public TriggerContextServer(ChannelAPI channel) {
        super(channel, "server_context");
    }

    @Override
    public void cache() {
        MinecraftServerAPI server = ServerHelper.getAPI();
        if (Objects.nonNull(server)) {
            try {
                this.player = server.getPlayerByUUID(this.channel.getHelper().getPlayerID());
            }
            catch (NullPointerException ignored) {
                this.logDebug("Caught NPE while trying to get player by UUID", new Object[0]);
                this.player = null;
            }
            this.world = Objects.nonNull(this.player) ? this.player.getWorld() : null;
        } else {
            this.player = null;
            this.world = null;
        }
        this.pos = this.hasBoth() ? this.player.getPosRounded() : null;
        StructureAPI<?> structureAPI = this.structure = Objects.nonNull(this.pos) ? this.world.getStructureAt(this.pos) : null;
        if (Objects.nonNull(this.structure)) {
            ResourceLocationAPI registryName;
            String name = this.structure.getName(this.world);
            if (Objects.isNull(name) || name.isEmpty()) {
                name = "?";
            }
            this.checkStructureSync(name, Objects.nonNull(registryName = this.structure.getRegistryName(this.world)) ? registryName.toString() : "?");
        } else if (Objects.nonNull(this.player)) {
            this.checkStructureSync("?", "?");
        }
    }

    private boolean checkEntity(TriggerMob trigger, EntityAPI<?, ?> entity) {
        ResourceContext ctx = trigger.getResourceCtx();
        return Objects.nonNull(ctx) && this.checkEntityName(ctx, entity) && this.checkEntityNBT(trigger, entity) && this.checkEntityMods(trigger, entity);
    }

    private boolean checkEntityChampion(TriggerMob trigger, EntityAPI<?, ?> entity) {
        ChampionsAPI champions = ModHelper.champions();
        if (Objects.nonNull(champions)) {
            List<?> championNames = trigger.getParameterAsList("champion");
            if (championNames.isEmpty() || championNames.contains("any")) {
                return true;
            }
            ChampionsAPI.ChampionData data = champions.getChampionData(entity);
            if (Objects.nonNull(data)) {
                for (String name : championNames) {
                    for (String affix : data.getAffixes()) {
                        if (!affix.contains(name)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkEntityInfernal(TriggerMob trigger, EntityAPI<?, ?> entity) {
        InfernalMobsAPI infernalMobs = ModHelper.infernalMobs();
        if (Objects.nonNull(infernalMobs)) {
            List<?> infernalNames = trigger.getParameterAsList("infernal");
            if (infernalNames.isEmpty() || infernalNames.contains("any")) {
                return true;
            }
            InfernalMobsAPI.InfernalData data = infernalMobs.getInfernalData(entity);
            if (Objects.nonNull(data)) {
                for (String name : infernalNames) {
                    for (String display : data.getDisplayNames()) {
                        if (!display.contains(name)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkEntityMods(TriggerMob trigger, EntityAPI<?, ?> entity) {
        return this.checkEntityChampion(trigger, entity) && this.checkEntityInfernal(trigger, entity);
    }

    private boolean checkEntityName(ResourceContext ctx, EntityAPI<?, ?> entity) {
        if (ctx.getResourcesMatchers().contains("MOB")) {
            return entity.isHostile();
        }
        ResourceLocationAPI regName = entity.getRegistryName(this.world);
        if (Objects.isNull(regName)) {
            return false;
        }
        String name = entity.getName();
        return ctx.checkMatch(regName.toString(), TextHelper.isNotBlank((String)name) ? name : null);
    }

    private boolean checkEntityNBT(TriggerMob trigger, EntityAPI<?, ?> entity) {
        List<?> nbtCheckers = trigger.getNBTParameter();
        if (nbtCheckers.contains("any")) {
            return true;
        }
        CompoundTagAPI entityData = entity.getData();
        for (Object checkThis : nbtCheckers) {
            if (!this.checkNBT(entityData, String.valueOf(checkThis))) continue;
            return true;
        }
        return false;
    }

    private Set<EntityAPI<?, ?>> getEntitiesAround(TriggerMob trigger) {
        int range = trigger.getParameterAsInt("detection_range");
        float rangeRatioY = trigger.getParameterAsFloat("detection_y_ratio");
        List<EntityAPI<?, ?>> entities = this.getEntitiesAround(this.getBox(range, rangeRatioY));
        HashSet aliveEntities = new HashSet();
        for (EntityAPI<?, ?> entity : entities) {
            if (!entity.isAlive()) continue;
            aliveEntities.add(entity);
        }
        return aliveEntities;
    }

    private void checkStructureSync(String name, String id) {
        if (this.previousStructureName.equals(name) && this.getPreviousStructureID.equals(id)) {
            return;
        }
        ChannelHelper helper = this.channel.getHelper();
        for (ChannelAPI channel : helper.getChannels().values()) {
            TriggerContext ctx = channel.getSelector().getContext();
            if (!(ctx instanceof TriggerContextServer)) continue;
            TriggerContextServer serverCtx = (TriggerContextServer)ctx;
            serverCtx.previousStructureName = name;
            serverCtx.getPreviousStructureID = id;
        }
        MessageCurrentStructure message = new MessageCurrentStructure(helper, name, id);
        MTNetwork.sendToClient(message, message.getUuid());
    }

    @Override
    public boolean isActiveAcidRain() {
        return false;
    }

    @Override
    public boolean isActiveAdvancement(ResourceContext ctx) {
        return false;
    }

    @Override
    public boolean isActiveAdventure() {
        return false;
    }

    @Override
    public boolean isActiveBiome(TriggerBiome trigger) {
        return false;
    }

    @Override
    public boolean isActiveBlizzard() {
        return false;
    }

    @Override
    public boolean isActiveBlockEntity(ResourceContext ctx, int range, float yRatio) {
        return false;
    }

    @Override
    public boolean isActiveBloodMoon() {
        return false;
    }

    @Override
    public boolean isActiveBlueMoon() {
        return false;
    }

    @Override
    public boolean isActiveCloudy() {
        return false;
    }

    @Override
    public boolean isActiveCommand(TriggerCommand trigger) {
        return trigger.hasCount();
    }

    @Override
    public boolean isActiveCreative() {
        return false;
    }

    @Override
    public boolean isActiveDead() {
        return false;
    }

    @Override
    public boolean isActiveDifficulty(int level) {
        return false;
    }

    @Override
    public boolean isActiveDimension(ResourceContext ctx) {
        return false;
    }

    @Override
    public boolean isActiveDrowning(int level) {
        return false;
    }

    @Override
    public boolean isActiveEffect(ResourceContext ctx) {
        return false;
    }

    @Override
    public boolean isActiveElytra() {
        return false;
    }

    @Override
    public boolean isActiveStarShower() {
        return false;
    }

    @Override
    public boolean isActiveFishing() {
        return false;
    }

    @Override
    public boolean isActiveGamestage(ResourceContext ctx, boolean whitelist) {
        return false;
    }

    @Override
    public boolean isActiveGeneric() {
        return false;
    }

    @Override
    public boolean isActiveGUI(ResourceContext ctx) {
        return false;
    }

    @Override
    public boolean isActiveHarvestMoon() {
        return false;
    }

    @Override
    public boolean isActiveHeight(int level, boolean checkSky, boolean checkAbove) {
        return false;
    }

    @Override
    public boolean isActiveHome(int range, float yRatio) {
        if (Objects.isNull(this.pos) || Objects.isNull(this.player)) {
            return false;
        }
        BlockPosAPI bed = this.player.getBedPos(this.player.getDimension());
        return Objects.nonNull(bed) && this.isCloseEnough(bed.x(), bed.y(), bed.z(), range, yRatio, this.pos.x(), this.pos.y(), this.pos.z());
    }

    @Override
    public boolean isActiveHurricane(int range) {
        return false;
    }

    @Override
    public boolean isActiveInventory(List<String> items, List<String> slots) {
        return false;
    }

    @Override
    public boolean isActiveLight(int level, String type) {
        return false;
    }

    @Override
    public boolean isActiveLightRain() {
        return false;
    }

    @Override
    public boolean isActiveLoading() {
        return false;
    }

    @Override
    public boolean isActiveLowHP(float minPercent, float maxPercent) {
        return false;
    }

    @Override
    public boolean isActiveMenu() {
        return false;
    }

    @Override
    public boolean isActiveMob(TriggerMob trigger) {
        if (Objects.isNull(this.pos)) {
            return false;
        }
        trigger.cacheParameters();
        Set<EntityAPI<?, ?>> entitiesAround = this.getEntitiesAround(trigger);
        trigger.deduplicate(entitiesAround);
        trigger.revalidateCache(this.pos, this.player);
        for (EntityAPI<?, ?> entity : entitiesAround) {
            if (!this.checkEntity(trigger, entity)) continue;
            trigger.cacheValidEntity(entity, this.player);
        }
        return trigger.checkCacheSize();
    }

    @Override
    public boolean isActiveMoon(ResourceContext ctx) {
        return false;
    }

    @Override
    public boolean isActivePet(int range, float yRatio) {
        return false;
    }

    @Override
    public boolean isActivePVP() {
        return false;
    }

    @Override
    public boolean isActiveRaid(List<?> statusChecks, int wave) {
        if (Objects.isNull(this.pos) || this.world.getRaidWave(this.pos) < wave) {
            return false;
        }
        if (statusChecks.contains("any")) {
            return true;
        }
        String status = this.world.getRaidStatus(this.pos);
        if (Objects.isNull(status)) {
            return false;
        }
        for (Object check : statusChecks) {
            if (!status.equalsIgnoreCase(String.valueOf(check))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActiveRaining() {
        return false;
    }

    @Override
    public boolean isActiveRainIntensity(float level) {
        return false;
    }

    @Override
    public boolean isActiveRiding(ResourceContext ctx) {
        return false;
    }

    @Override
    public boolean isActiveSandstorm(int range) {
        return false;
    }

    @Override
    public boolean isActiveSeason(int level) {
        return false;
    }

    @Override
    public boolean isActiveSnowing() {
        return false;
    }

    @Override
    public boolean isActiveSpectator() {
        return false;
    }

    @Override
    public boolean isActiveStatistic(ResourceContext ctx, int level) {
        return false;
    }

    @Override
    public boolean isActiveStorming() {
        return false;
    }

    @Override
    public boolean isActiveStructure(ResourceContext ctx) {
        return Objects.nonNull(this.structure) && ctx.checkMatch(this.structure.getRegistryName(this.world).toString(), this.structure.getName(this.world));
    }

    @Override
    public boolean isActiveTime(String bundle, float startHour, float endHour, int startDay, int endDay, int moonPhase) {
        return false;
    }

    @Override
    public boolean isActiveTornado(int range, int level) {
        return false;
    }

    @Override
    public boolean isActiveUnderwater() {
        return false;
    }

    @Override
    public boolean isActiveVictory(int timeout) {
        return false;
    }

    @Override
    public boolean isActiveZones(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return false;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Generated
    public void setGetPreviousStructureID(String getPreviousStructureID) {
        this.getPreviousStructureID = getPreviousStructureID;
    }

    @Generated
    public void setPreviousStructureName(String previousStructureName) {
        this.previousStructureName = previousStructureName;
    }
}

