/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.network;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerHelper;
import mods.thecomputerizer.musictriggers.api.network.ChannelHelperMessage;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.IterableHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;

public class MessageTriggerStates<CTX>
extends ChannelHelperMessage<CTX> {
    private final Map<ChannelAPI, Map<TriggerAPI, TriggerAPI.State>> triggerMap;

    public MessageTriggerStates(ChannelHelper helper) {
        super(helper);
        this.triggerMap = new HashMap<ChannelAPI, Map<TriggerAPI, TriggerAPI.State>>();
    }

    public MessageTriggerStates(ByteBuf buf) {
        super(buf);
        this.triggerMap = NetworkHelper.readMapEntries((ByteBuf)buf, () -> {
            ChannelAPI channel = this.helper.findChannel(ChannelHelper.getGlobalData(), NetworkHelper.readString((ByteBuf)buf));
            Map stateMap = NetworkHelper.readMap((ByteBuf)buf, () -> TriggerHelper.decodeTrigger(channel, buf), () -> TriggerAPI.State.valueOf(NetworkHelper.readString((ByteBuf)buf)));
            return IterableHelper.getMapEntry((Object)channel, (Object)stateMap);
        });
    }

    public void addStates(Collection<TriggerAPI> triggers) {
        for (TriggerAPI trigger : triggers) {
            ChannelAPI channel = trigger.getChannel();
            this.triggerMap.putIfAbsent(channel, new HashMap());
            this.triggerMap.get(channel).put(trigger, trigger.getState());
        }
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        NetworkHelper.writeMap((ByteBuf)buf, this.triggerMap, channel -> NetworkHelper.writeString((ByteBuf)buf, (String)channel.getName()), stateMap -> NetworkHelper.writeMap((ByteBuf)buf, (Map)stateMap, trigger -> trigger.encode(buf), state -> NetworkHelper.writeString((ByteBuf)buf, (String)state.name())));
    }

    public void handle() {
        this.triggerMap.forEach(ChannelAPI::updateSyncedState);
    }

    public MessageAPI<CTX> handle(CTX ctx) {
        this.helper.tryHandleTriggerStateSync(this);
        return null;
    }

    public boolean readyToSend() {
        if (!this.triggerMap.isEmpty() && this.helper.isSyncable()) {
            for (Map<TriggerAPI, TriggerAPI.State> stateMap : this.triggerMap.values()) {
                if (stateMap.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

