/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.network;

import java.util.Objects;
import javax.annotation.Nullable;
import mods.thecomputerizer.musictriggers.api.MTRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelHelper;
import mods.thecomputerizer.musictriggers.api.network.MessageCurrentSong;
import mods.thecomputerizer.musictriggers.api.network.MessageCurrentStructure;
import mods.thecomputerizer.musictriggers.api.network.MessageFinishedInit;
import mods.thecomputerizer.musictriggers.api.network.MessageInitChannels;
import mods.thecomputerizer.musictriggers.api.network.MessageNBTCheck;
import mods.thecomputerizer.musictriggers.api.network.MessageReload;
import mods.thecomputerizer.musictriggers.api.network.MessageRequestChannels;
import mods.thecomputerizer.musictriggers.api.network.MessageSeekSong;
import mods.thecomputerizer.musictriggers.api.network.MessageSkipSong;
import mods.thecomputerizer.musictriggers.api.network.MessageToggleDebugParameter;
import mods.thecomputerizer.musictriggers.api.network.MessageTriggerStates;
import mods.thecomputerizer.musictriggers.api.network.PlayerMessage;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHandler;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.ServerHelper;

public class MTNetwork {
    public static void initClient() {
        MTRef.logInfo("Initializing client network", new Object[0]);
        NetworkHandler.registerMsgToServer(MessageCurrentSong.class, MessageCurrentSong::new);
        NetworkHandler.registerMsgToServer(MessageFinishedInit.class, MessageFinishedInit::new);
        NetworkHandler.registerMsgToServer(MessageInitChannels.class, MessageInitChannels::new);
        NetworkHandler.registerMsgToServer(MessageReload.class, MessageReload::new);
        NetworkHandler.registerMsgToServer(MessageRequestChannels.class, MessageRequestChannels::new);
        NetworkHandler.registerMsgToServer(MessageSkipSong.class, MessageSkipSong::new);
        NetworkHandler.registerMsgToServer(MessageTriggerStates.class, MessageTriggerStates::new);
        NetworkHandler.registerMsgToServerLogin(MessageFinishedInit.class, MessageFinishedInit::new);
        NetworkHandler.registerMsgToServerLogin(MessageInitChannels.class, MessageInitChannels::new);
        NetworkHandler.registerMsgToServerLogin(MessageRequestChannels.class, MessageRequestChannels::new);
    }

    public static void initCommon() {
        MTRef.logInfo("Initializing common network", new Object[0]);
        NetworkHandler.registerMsgToClient(MessageCurrentStructure.class, MessageCurrentStructure::new);
        NetworkHandler.registerMsgToClient(MessageFinishedInit.class, MessageFinishedInit::new);
        NetworkHandler.registerMsgToClient(MessageInitChannels.class, MessageInitChannels::new);
        NetworkHandler.registerMsgToClient(MessageNBTCheck.class, MessageNBTCheck::new);
        NetworkHandler.registerMsgToClient(MessageReload.class, MessageReload::new);
        NetworkHandler.registerMsgToClient(MessageRequestChannels.class, MessageRequestChannels::new);
        NetworkHandler.registerMsgToClient(MessageSeekSong.class, MessageSeekSong::new);
        NetworkHandler.registerMsgToClient(MessageSkipSong.class, MessageSkipSong::new);
        NetworkHandler.registerMsgToClient(MessageToggleDebugParameter.class, MessageToggleDebugParameter::new);
        NetworkHandler.registerMsgToClient(MessageTriggerStates.class, MessageTriggerStates::new);
        NetworkHandler.registerMsgToClientLogin(MessageFinishedInit.class, MessageFinishedInit::new);
        NetworkHandler.registerMsgToClientLogin(MessageInitChannels.class, MessageInitChannels::new);
        NetworkHandler.registerMsgToClientLogin(MessageRequestChannels.class, MessageRequestChannels::new);
    }

    private static void finalizePlayerMsg(MessageAPI<?> msg, boolean login, @Nullable String uuid) {
        if (msg instanceof PlayerMessage) {
            PlayerMessage playerMsg = (PlayerMessage)msg;
            playerMsg.setLogin(login);
            if (Objects.nonNull(uuid)) {
                playerMsg.setUuid(uuid);
            }
        }
    }

    public static boolean send(MessageAPI<?> msg, ChannelHelper helper, boolean login) {
        if (helper.isClient()) {
            MTNetwork.sendToServer(msg, login);
        } else {
            String uuid = helper.getPlayerID();
            if (Objects.isNull(uuid)) {
                return false;
            }
            MTNetwork.sendToClient(msg, login, uuid);
        }
        return true;
    }

    public static void sendToClient(MessageAPI<?> msg, String uuid) {
        MTNetwork.sendToClient(msg, false, uuid);
    }

    public static void sendToClient(MessageAPI<?> msg, boolean login, String uuid) {
        MinecraftServerAPI server = ServerHelper.getAPI();
        if (Objects.nonNull(server)) {
            PlayerAPI player = server.getPlayerByUUID(uuid);
            MTNetwork.sendToClient(msg, login, player);
        } else {
            MTRef.logError("Failed to send message to the client since the server is null!", new Object[0]);
        }
    }

    public static <P> void sendToClient(MessageAPI<?> msg, boolean login, @Nullable PlayerAPI<P, ?> player) {
        MTNetwork.finalizePlayerMsg(msg, login, Objects.nonNull(player) ? player.getUUID().toString() : null);
        MTNetwork.sendToClient(msg, login, Objects.nonNull(player) ? player.getEntity() : null);
    }

    public static <P, D> void sendToClient(MessageAPI<?> msg, boolean login, @Nullable P player) {
        Object direction = login ? NetworkHelper.getDirToClientLogin() : NetworkHelper.getDirToClient();
        MessageWrapperAPI wrapper = NetworkHelper.wrapMessage((Object)direction, msg);
        if (Objects.nonNull(wrapper)) {
            if (Objects.nonNull(player)) {
                wrapper.setPlayer(player);
                wrapper.send();
            } else {
                MTRef.logError("Cannot send message to null player!", new Object[0]);
            }
        } else {
            MTRef.logError("Cannot null message to a player!", new Object[0]);
        }
    }

    public static void sendToServer(MessageAPI<?> msg) {
        MTNetwork.sendToServer(msg, false);
    }

    public static <D> void sendToServer(MessageAPI<?> msg, boolean login) {
        ChannelHelper helper = ChannelHelper.getClientHelper();
        MTNetwork.finalizePlayerMsg(msg, login, Objects.nonNull(helper) ? helper.getPlayerID() : null);
        Object direction = login ? NetworkHelper.getDirToServerLogin() : NetworkHelper.getDirToServer();
        MessageWrapperAPI wrapper = NetworkHelper.wrapMessage((Object)direction, msg);
        if (Objects.nonNull(wrapper)) {
            wrapper.send();
        } else {
            MTRef.logError("Cannot null message to the server!", new Object[0]);
        }
    }
}

