/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger.holder;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.HolderTrigger;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;

public class TriggerMob
extends HolderTrigger {
    protected final Set<EntityAPI<?, ?>> cachedEntities = new HashSet();
    protected int cachedHordeHealthCount;
    protected int cachedHordeTargetingCount;
    protected int cachedMaxEntities = Integer.MAX_VALUE;
    protected int cachedMinEntities;
    protected float cachedMaxHealth = 1.0f;
    protected float cachedMinHealth;
    protected int cachedRangeXZ;
    protected int cachedRangeY;

    public TriggerMob(ChannelAPI channel) {
        super(channel, "mob");
    }

    protected int cacheHordeParameter(String name) {
        float percent = Math.min(1.0f, this.getParameterAsFloat(name) / 100.0f);
        if (this.cachedMaxEntities == Integer.MAX_VALUE) {
            return percent <= 0.0f ? 0 : this.cachedMinEntities;
        }
        return Math.max(this.cachedMinEntities, (int)((float)this.cachedMaxEntities * percent));
    }

    public void cacheParameters() {
        this.cachedMaxEntities = this.getParameterAsInt("max_entities");
        this.cachedMinEntities = this.getParameterAsInt("min_entities");
        this.cachedHordeHealthCount = this.cacheHordeParameter("horde_health_percentage");
        this.cachedHordeTargetingCount = this.cacheHordeParameter("horde_targeting_percentage");
        this.cachedMinHealth = this.getParameterAsFloat("min_health") / 100.0f;
        this.cachedMaxHealth = this.getParameterAsFloat("max_health") / 100.0f;
        this.cachedRangeXZ = this.getParameterAsInt("detection_range");
        this.cachedRangeY = (int)((float)this.cachedRangeXZ * this.getParameterAsFloat("detection_y_ratio"));
    }

    public void cacheValidEntity(EntityAPI<?, ?> entity, PlayerAPI<?, ?> player) {
        if (this.checkHealth(entity) && this.checkTarget(entity, player)) {
            this.cachedEntities.add(entity);
        }
    }

    public boolean checkCacheSize() {
        int size = this.cachedEntities.size();
        this.cachedEntities.clear();
        return size >= this.cachedMinEntities && size <= this.cachedMaxEntities && size >= this.cachedHordeHealthCount && size >= this.cachedHordeTargetingCount;
    }

    public boolean checkEntityFarAway(EntityAPI<?, ?> entity, BlockPosAPI<?> pos) {
        if (Objects.isNull(entity) || Objects.isNull(pos) || entity.isLiving() && !entity.isAlive()) {
            return true;
        }
        BlockPosAPI ePos = entity.getPos();
        int xDif = Math.abs(ePos.x() - pos.x());
        int yDif = Math.abs(ePos.y() - pos.y());
        int zDif = Math.abs(ePos.z() - pos.z());
        return xDif > this.cachedRangeXZ || yDif > this.cachedRangeY || zDif > this.cachedRangeXZ;
    }

    public boolean checkHealth(EntityAPI<?, ?> entity) {
        if (Objects.isNull(entity) || !entity.isAlive()) {
            return false;
        }
        if (entity.isLiving()) {
            LivingEntityAPI living = WrapperHelper.wrapLivingEntity((Object)entity.getEntity());
            if (Objects.isNull(living) || !living.isAlive()) {
                return false;
            }
            float percent = living.getHealthPercent();
            return this.cachedMinHealth < percent && this.cachedMaxHealth >= percent;
        }
        return true;
    }

    public boolean checkTarget(EntityAPI<?, ?> entity, PlayerAPI<?, ?> player) {
        if (!(this.getParameterAsBoolean("mob_targeting") && entity.canTarget() && entity.isHostile())) {
            return true;
        }
        EntityAPI target = entity.getAttackTarget();
        if (Objects.isNull(target) || !target.isPlayer() || Objects.isNull(player)) {
            return false;
        }
        return this.getParameterAsBoolean("target_any_player") || target.getEntity() == player.getEntity();
    }

    public void deduplicate(Collection<EntityAPI<?, ?>> entities) {
        for (EntityAPI<?, ?> entity : this.cachedEntities) {
            Object unwrapped = entity.getEntity();
            entities.removeIf(e -> e.getEntity().equals(unwrapped));
        }
    }

    public List<?> getNBTParameter() {
        return this.getParameterAsList("mob_nbt");
    }

    @Override
    public boolean imply(String id) {
        this.setExistingParameterValue("resource_name", Collections.singletonList(id));
        return super.imply(id);
    }

    @Override
    public boolean isPlayableContext(TriggerContext ctx) {
        return ctx.isActiveMob(this);
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public void revalidateCache(BlockPosAPI<?> pos, PlayerAPI<?, ?> player) {
        this.cachedEntities.removeIf(entity -> this.checkEntityFarAway((EntityAPI<?, ?>)entity, pos) || !this.checkHealth((EntityAPI<?, ?>)entity) || !this.checkTarget((EntityAPI<?, ?>)entity, player));
    }

    @Override
    public boolean verifyRequiredParameters() {
        if (this.hasValidIdentifier()) {
            String[] parameters = new String[]{"display_name", "resource_name"};
            if (this.hasAnyNonDefaultParameter(parameters)) {
                return true;
            }
            this.logMissingPotentialParameter(parameters);
        }
        return false;
    }
}

