/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger.holder;

import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.HolderTrigger;

public class TriggerLight
extends HolderTrigger {
    public TriggerLight(ChannelAPI channel) {
        super(channel, "light");
    }

    @Override
    public boolean imply(String id) {
        try {
            int level = Integer.parseInt(id);
            if (level < 0 || level > 15) {
                throw new NumberFormatException("Integer must be in the bounds [0,15]");
            }
            this.setExistingParameterValue("level", level);
        }
        catch (NumberFormatException ex) {
            this.logError("Failed to imply level from identifier {} (must be a bounded integer between [0,15])", id, ex);
        }
        return super.imply(id);
    }

    @Override
    public boolean isPlayableContext(TriggerContext ctx) {
        return ctx.isActiveLight(this.getParameterAsInt("level"), this.getParameterAsString("light_type").toLowerCase());
    }

    @Override
    public boolean verifyRequiredParameters() {
        if (this.hasValidIdentifier()) {
            return true;
        }
        this.logMissingParameter("identifier");
        return false;
    }
}

