/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.audio.AudioPool;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.musictriggers.api.data.parameter.Parameter;
import mods.thecomputerizer.musictriggers.api.data.parameter.UniversalParameters;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerCombination;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;

public class TriggerMerged
extends TriggerAPI {
    private final Collection<TriggerAPI> triggers;
    private TriggerAPI playing;

    public TriggerMerged(ChannelAPI channel, Collection<TriggerAPI> triggers) {
        super(channel, "merged");
        this.triggers = triggers;
    }

    @Override
    public void activate() {
        super.activate();
        this.triggers.forEach(TriggerAPI::activate);
    }

    @Override
    public void close() {
        super.close();
        this.triggers.forEach(TriggerAPI::close);
        this.triggers.clear();
        this.playing = null;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.triggers.forEach(TriggerAPI::deactivate);
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        NetworkHelper.writeCollection((ByteBuf)buf, this.triggers, trigger -> trigger.encode(buf));
    }

    protected void executePlaying(Consumer<TriggerAPI> executor, Consumer<Void> superExecutor) {
        TriggerAPI playing = this.getOrSetPlaying();
        if (Objects.nonNull(playing)) {
            executor.accept(playing);
        } else {
            superExecutor.accept(null);
        }
    }

    @Override
    @Nullable
    public AudioPool getAudioPool() {
        return this.returnPlaying(TriggerAPI::getAudioPool, () -> super.getAudioPool());
    }

    @Override
    public String getName() {
        StringJoiner joiner = new StringJoiner("+");
        for (TriggerAPI trigger : this.triggers) {
            joiner.add(trigger.getNameWithID());
        }
        return this.triggers.size() == 1 ? joiner.toString() : "merged = " + joiner;
    }

    @Override
    public String getNameWithID() {
        return this.getName();
    }

    protected TriggerAPI getOrSetPlaying() {
        if (Objects.isNull(this.playing)) {
            this.playing = this.getRandomTrigger();
        }
        return this.playing;
    }

    @Override
    @Nullable
    public Parameter<?> getParameter(String name) {
        return this.returnPlaying(playing -> playing.getParameter(name), () -> super.getParameter(name));
    }

    @Nullable
    public TriggerAPI getRandomTrigger() {
        if (this.triggers.isEmpty()) {
            return null;
        }
        TriggerAPI trigger = (TriggerAPI)RandomHelper.getBasicRandomEntry(this.triggers);
        return trigger instanceof TriggerMerged ? ((TriggerMerged)trigger).getRandomTrigger() : trigger;
    }

    @Override
    protected void initExtraParameters(Map<String, Parameter<?>> map) {
    }

    @Override
    public boolean isPlayableContext(TriggerContext context) {
        for (TriggerAPI trigger : this.triggers) {
            if (!trigger.isPlayableContext(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isContained(Collection<TriggerAPI> triggers) {
        for (TriggerAPI trigger : this.triggers) {
            if (!trigger.isContained(triggers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Collection<TriggerAPI> triggers) {
        return TriggerHelper.matchesAll(this.triggers, triggers);
    }

    @Override
    public boolean matches(TriggerAPI other) {
        if (other instanceof TriggerMerged) {
            return TriggerHelper.matchesAny(this.triggers, ((TriggerMerged)other).triggers);
        }
        if (other instanceof TriggerCombination) {
            return other.isContained(this.triggers);
        }
        for (TriggerAPI trigger : this.triggers) {
            if (!trigger.matches(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean query(TriggerContext context) {
        return !this.triggers.isEmpty() && super.query(context);
    }

    @Override
    public void queue() {
        this.executePlaying(ChannelElement::queue, v -> super.queue());
    }

    protected <V> V returnPlaying(Function<TriggerAPI, V> func, Supplier<V> superReturn) {
        TriggerAPI playing = this.getOrSetPlaying();
        return Objects.nonNull(playing) ? func.apply(playing) : superReturn.get();
    }

    @Override
    public void setUniversals(UniversalParameters universals) {
        super.setUniversals(universals);
        this.triggers.forEach(trigger -> trigger.setUniversals(universals));
    }

    @Override
    public void stopped() {
        this.executePlaying(playing -> {
            playing.stopped();
            this.playing = null;
        }, v -> {});
    }

    @Generated
    public Collection<TriggerAPI> getTriggers() {
        return this.triggers;
    }

    @Generated
    public TriggerAPI getPlaying() {
        return this.playing;
    }
}

