/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.musictriggers.api.data.trigger;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import mods.thecomputerizer.musictriggers.api.data.MTDataRef;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelAPI;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelData;
import mods.thecomputerizer.musictriggers.api.data.channel.ChannelElement;
import mods.thecomputerizer.musictriggers.api.data.nbt.NBTHelper;
import mods.thecomputerizer.musictriggers.api.data.nbt.mode.NBTMode;
import mods.thecomputerizer.musictriggers.api.data.parameter.ParameterWrapper;
import mods.thecomputerizer.musictriggers.api.data.trigger.ResourceContext;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerAPI;
import mods.thecomputerizer.musictriggers.api.data.trigger.TriggerSynced;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerBiome;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerCommand;
import mods.thecomputerizer.musictriggers.api.data.trigger.holder.TriggerMob;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.BaseTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;

public abstract class TriggerContext
extends ChannelElement {
    protected final Set<TriggerSynced> syncedTriggers = new HashSet<TriggerSynced>();
    protected BiomeAPI<?> biome;
    protected PlayerAPI<?, ?> player;
    protected BlockPosAPI<?> pos;
    protected WorldAPI<?> world;

    protected TriggerContext(ChannelAPI channel, String name) {
        super(channel, name);
    }

    public abstract void cache();

    protected boolean checkNBT(@Nullable CompoundTagAPI<?> tag, String tagStr) {
        if (Objects.isNull(tag) || TextHelper.isBlank((String)tagStr) || tagStr.equalsIgnoreCase("any")) {
            return true;
        }
        NBTMode mode = NBTHelper.getAndInitMode(tagStr.split(";"));
        try {
            return Objects.nonNull(mode) && mode.checkMatch(this.channel, (BaseTagAPI<?>)tag);
        }
        catch (NumberFormatException ex) {
            this.logError("Tried to check numerical value of NBT data against a non numerical value in `{}`", tagStr, ex);
        }
        catch (Exception ex) {
            this.logError("Caught an unknown error when attempting to check NBT data for `{}`", tagStr, ex);
        }
        return false;
    }

    public void clearSync() {
        this.logInfo("Clearing syncable {} side data", this.isClient() ? "client" : "server");
        this.syncedTriggers.clear();
    }

    @Override
    public void close() {
        this.player = null;
        this.world = null;
    }

    protected Box getBox(int range, float yRatio) {
        return this.getBox((double)range, (double)range * (double)yRatio);
    }

    protected Box getBox(double hRange, double vRange) {
        Vector3 pos = this.player.getPosRounded().getPosVec();
        double x = pos.dX();
        double y = pos.dY();
        double z = pos.dZ();
        return ShapeHelper.box((double)(x - hRange), (double)(y - vRange), (double)(z - hRange), (double)(x + hRange), (double)(y + vRange), (double)(z + hRange));
    }

    protected Collection<BlockEntityAPI<?, ?>> getBlockEntitiesAround(Box box) {
        return this.hasBoth() ? this.world.getBlockEntitiesInBox(box) : Collections.emptyList();
    }

    protected List<EntityAPI<?, ?>> getEntitiesAround(Box box) {
        return this.hasBoth() ? this.world.getEntitiesInBox(box) : Collections.emptyList();
    }

    @Override
    public MTDataRef.TableRef getReferenceData() {
        return null;
    }

    @Override
    protected String getSubTypeName() {
        return "Trigger";
    }

    protected boolean getSyncedContext(TriggerAPI trigger) {
        TriggerSynced synced = this.getSyncedTrigger(trigger);
        return Objects.nonNull(synced) && synced.isPlayableContext(this);
    }

    public TriggerAPI.State getSyncedState(TriggerAPI trigger) {
        TriggerSynced synced = this.getSyncedTrigger(trigger);
        return Objects.nonNull(synced) ? synced.getState() : TriggerAPI.State.DISABLED;
    }

    protected TriggerSynced getSyncedTrigger(TriggerAPI trigger) {
        for (TriggerSynced synced : this.syncedTriggers) {
            if (!synced.matches(trigger)) continue;
            return synced;
        }
        return null;
    }

    @Override
    public Class<? extends ParameterWrapper> getTypeClass() {
        return TriggerContext.class;
    }

    protected boolean hasBoth() {
        return this.hasPlayer() && this.hasWorld();
    }

    protected boolean hasPlayer() {
        return Objects.nonNull(this.player);
    }

    protected boolean hasWorld() {
        return Objects.nonNull(this.world);
    }

    public void initSync() {
        this.logInfo("Initializing syncable {} side data", this.isClient() ? "client" : "server");
        ChannelData data = this.channel.getData();
        for (TriggerAPI trigger : data.getTriggers()) {
            if (!trigger.isSynced()) continue;
            this.syncedTriggers.add(new TriggerSynced(this.channel, trigger));
        }
        HashMap<TriggerAPI, TriggerSynced> syncedMap = new HashMap();
        if (this.syncedTriggers.isEmpty()) {
            syncedMap = Collections.emptyMap();
        } else {
            for (TriggerSynced synced : this.syncedTriggers) {
                syncedMap.put(synced.getReference(), synced);
            }
        }
        data.afterTriggerSync(syncedMap);
    }

    public abstract boolean isActiveAcidRain();

    public abstract boolean isActiveAdvancement(ResourceContext var1);

    public abstract boolean isActiveAdventure();

    public abstract boolean isActiveBiome(TriggerBiome var1);

    public abstract boolean isActiveBlizzard();

    public abstract boolean isActiveBlockEntity(ResourceContext var1, int var2, float var3);

    public abstract boolean isActiveBloodMoon();

    public abstract boolean isActiveBlueMoon();

    public abstract boolean isActiveCloudy();

    public abstract boolean isActiveCommand(TriggerCommand var1);

    public abstract boolean isActiveCreative();

    public abstract boolean isActiveDead();

    public abstract boolean isActiveDifficulty(int var1);

    public abstract boolean isActiveDimension(ResourceContext var1);

    public abstract boolean isActiveDrowning(int var1);

    public abstract boolean isActiveEffect(ResourceContext var1);

    public abstract boolean isActiveElytra();

    public abstract boolean isActiveStarShower();

    public abstract boolean isActiveFishing();

    public abstract boolean isActiveGamestage(ResourceContext var1, boolean var2);

    public abstract boolean isActiveGeneric();

    public abstract boolean isActiveGUI(ResourceContext var1);

    public abstract boolean isActiveHarvestMoon();

    public abstract boolean isActiveHeight(int var1, boolean var2, boolean var3);

    public abstract boolean isActiveHome(int var1, float var2);

    public abstract boolean isActiveHurricane(int var1);

    public abstract boolean isActiveInventory(List<String> var1, List<String> var2);

    public abstract boolean isActiveLight(int var1, String var2);

    public abstract boolean isActiveLightRain();

    public abstract boolean isActiveLoading();

    public abstract boolean isActiveLowHP(float var1, float var2);

    public abstract boolean isActiveMenu();

    public abstract boolean isActiveMob(TriggerMob var1);

    public abstract boolean isActiveMoon(ResourceContext var1);

    public abstract boolean isActivePet(int var1, float var2);

    public abstract boolean isActivePVP();

    public abstract boolean isActiveRaid(List<?> var1, int var2);

    public abstract boolean isActiveRaining();

    public abstract boolean isActiveRainIntensity(float var1);

    public abstract boolean isActiveRiding(ResourceContext var1);

    public abstract boolean isActiveSandstorm(int var1);

    public abstract boolean isActiveSeason(int var1);

    public abstract boolean isActiveSnowing();

    public abstract boolean isActiveSpectator();

    public abstract boolean isActiveStatistic(ResourceContext var1, int var2);

    public abstract boolean isActiveStorming();

    public abstract boolean isActiveStructure(ResourceContext var1);

    public abstract boolean isActiveTime(String var1, float var2, float var3, int var4, int var5, int var6);

    public abstract boolean isActiveTornado(int var1, int var2);

    public abstract boolean isActiveUnderwater();

    public abstract boolean isActiveVictory(int var1);

    public abstract boolean isActiveZones(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract boolean isClient();

    private boolean isCloseEnough(double v1, double v2, double range) {
        double min = Math.min(v1, v2);
        double max = Math.max(v1, v2);
        return max - min <= range;
    }

    protected boolean isCloseEnough(int x1, int y1, int z1, double range, double yFactor, int x2, int y2, int z2) {
        return this.isCloseEnough(x1, x2, range) && this.isCloseEnough(y1, y2, range * yFactor) && this.isCloseEnough(z1, z2, range);
    }

    @Override
    public boolean isResource() {
        return false;
    }

    public void updateSyncedState(TriggerAPI trigger, TriggerAPI.State state) {
        for (TriggerSynced synced : this.syncedTriggers) {
            if (!synced.matches(trigger)) continue;
            synced.sync(state);
            break;
        }
    }

    @Generated
    public PlayerAPI<?, ?> getPlayer() {
        return this.player;
    }
}

